<?php
// visitor_tracker.php - Tempatkan di ROOT website
session_start();

try {
    // Cek apakah file koneksi.php ada di folder ini (root)
    if (file_exists('koneksi.php')) {
        include 'koneksi.php';
    } 
    // Jika tidak ada di root, coba dari folder admin
    elseif (file_exists('admin/koneksi.php')) {
        include 'admin/koneksi.php';
    }
    // Jika tidak ada, coba dari parent folder
    elseif (file_exists('../koneksi.php')) {
        include '../koneksi.php';
    }
    
    if (isset($conn) && $conn !== false) {
        // Cek apakah tabel visitors sudah ada, jika belum buat
        $check_table = mysqli_query($conn, "SHOW TABLES LIKE 'visitors'");
        
        if (mysqli_num_rows($check_table) == 0) {
            // Buat tabel visitors jika belum ada
            $create_table = "CREATE TABLE visitors (
                id INT AUTO_INCREMENT PRIMARY KEY,
                session_id VARCHAR(255) NOT NULL,
                ip_address VARCHAR(45),
                user_agent TEXT,
                page_visited VARCHAR(255),
                visit_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                UNIQUE KEY unique_session (session_id)
            )";
            
            mysqli_query($conn, $create_table);
        }
        
        // Data pengunjung
        $session_id = session_id();
        $ip_address = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
        $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
        $page_visited = $_SERVER['REQUEST_URI'] ?? '/';
        
        // Cek apakah session ini sudah tercatat dalam 30 menit terakhir
        $thirty_minutes_ago = date('Y-m-d H:i:s', strtotime('-30 minutes'));
        
        $check_visitor = mysqli_query($conn, 
            "SELECT id FROM visitors 
             WHERE session_id = '$session_id' 
             AND visit_time > '$thirty_minutes_ago' 
             LIMIT 1"
        );
        
        // Jika belum tercatat dalam 30 menit terakhir, tambahkan sebagai visitor baru
        if (mysqli_num_rows($check_visitor) == 0) {
            // Update record lama atau insert baru
            $check_existing = mysqli_query($conn, 
                "SELECT id FROM visitors WHERE session_id = '$session_id' LIMIT 1"
            );
            
            if (mysqli_num_rows($check_existing) > 0) {
                // Update waktu kunjungan yang sudah ada
                $update_query = "UPDATE visitors 
                                SET visit_time = NOW(), 
                                    page_visited = '$page_visited',
                                    ip_address = '$ip_address',
                                    user_agent = '$user_agent'
                                WHERE session_id = '$session_id'";
                mysqli_query($conn, $update_query);
            } else {
                // Insert visitor baru
                $insert_query = "INSERT INTO visitors (session_id, ip_address, user_agent, page_visited) 
                                VALUES ('$session_id', '$ip_address', '$user_agent', '$page_visited')";
                mysqli_query($conn, $insert_query);
            }
        }
    } else {
        // Jika koneksi tidak tersedia, lakukan tanpa database
        error_log("Visitor tracker: Database connection not available");
    }
} catch (Exception $e) {
    // Tangani error secara diam-diam
    error_log("Visitor tracker error: " . $e->getMessage());
}
?>