<?php
include 'koneksi.php';
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Daftar Treatment - Mahera Beauty</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    /* Reset dan base styles */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
      background: #faf8f5;
      color: #5d4037;
      line-height: 1.6;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }

    .container {
      flex: 1;
      display: flex;
      flex-direction: column;
      max-width: 1400px;
      margin: 0 auto;
      width: 100%;
    }

    /* Header */
    .header {
      text-align: center;
      padding: 40px 20px;
      background: white;
      border-bottom: 1px solid #e8d7c9;
      box-shadow: 0 2px 10px rgba(93, 64, 55, 0.05);
      position: relative;
    }

    .header h1 {
      font-size: 28px;
      font-weight: 600;
      color: #5d4037;
      margin-bottom: 10px;
      padding-right: 60px;
    }

    .header p {
      color: #8d6e63;
      font-size: 16px;
    }

    /* ================= HAMBURGER MENU ================= */
    .hamburger-btn {
        display: none;
        position: absolute;
        top: 30px;
        right: 20px;
        background: #8d6e63;
        border: none;
        width: 44px;
        height: 44px;
        border-radius: 8px;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        cursor: pointer;
        z-index: 1001;
        box-shadow: 0 2px 8px rgba(141, 110, 99, 0.3);
        transition: all 0.3s ease;
    }

    .hamburger-btn:hover {
        transform: scale(1.05);
        box-shadow: 0 4px 12px rgba(141, 110, 99, 0.4);
    }

    .hamburger-btn span {
        display: block;
        width: 20px;
        height: 2px;
        background: white;
        margin: 2px 0;
        border-radius: 1px;
        transition: all 0.3s ease;
    }

    /* Mobile Menu Overlay */
    .mobile-nav-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 999;
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .mobile-nav-overlay.active {
        display: block;
        opacity: 1;
    }

    /* Mobile Menu Sidebar */
    .mobile-nav {
        position: fixed;
        top: 0;
        right: -280px;
        width: 260px;
        height: 100%;
        background: #fffbf8;
        z-index: 1000;
        padding: 70px 20px 20px;
        box-shadow: -3px 0 15px rgba(0, 0, 0, 0.15);
        transition: right 0.3s ease;
        overflow-y: auto;
    }

    .mobile-nav.active {
        right: 0;
    }

    .mobile-nav a {
        display: block;
        text-decoration: none;
        background: #8d6e63;
        color: #fff;
        padding: 12px 16px;
        border-radius: 8px;
        margin: 8px 0;
        font-weight: 500;
        text-align: center;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(141, 110, 99, 0.2);
        font-size: 14px;
    }

    .mobile-nav a:hover {
        transform: translateX(-3px);
        background: #a1887f;
        box-shadow: 0 4px 12px rgba(141, 110, 99, 0.3);
    }

    .mobile-nav a.active {
      background: #5d4037;
    }

    /* Close button inside mobile menu */
    .close-menu {
        position: absolute;
        top: 15px;
        right: 15px;
        background: #5d4037;
        color: white;
        border: none;
        width: 36px;
        height: 36px;
        border-radius: 50%;
        font-size: 18px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }

    /* Navigation Desktop */
    .nav-desktop {
      display: flex;
      justify-content: center;
      gap: 12px;
      padding: 20px;
      margin-bottom: 20px;
      flex-wrap: wrap;
      background: white;
      border-bottom: 1px solid #e0d5cc;
      box-shadow: 0 2px 10px rgba(93, 64, 55, 0.05);
    }

    .nav-desktop a {
      padding: 12px 24px;
      text-decoration: none;
      border-radius: 8px;
      font-weight: 500;
      font-size: 14px;
      transition: all 0.3s ease;
      background: white;
      color: #795548;
      border: 1px solid #d7ccc8;
    }

    .nav-desktop a:hover {
      background: #8d6e63;
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(141, 110, 99, 0.2);
    }

    .nav-desktop a.active {
      background: #8d6e63;
      color: white;
      border-color: #8d6e63;
    }

    /* Main content */
    .main-content {
      flex: 1;
      padding: 30px;
    }

    /* Alert */
    .alert {
      background: #f0f7f0;
      border: 1px solid #d4edda;
      color: #155724;
      padding: 15px 20px;
      border-radius: 8px;
      margin-bottom: 25px;
      font-size: 14px;
      max-width: 800px;
      margin-left: auto;
      margin-right: auto;
    }

    .alert.error {
      background: #f8d7da;
      border: 1px solid #f5c6cb;
      color: #721c24;
    }

    /* Grid container */
    .grid-container {
      max-width: 1400px;
      margin: 0 auto;
    }

    /* Treatment Grid */
    .treatment-grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
      gap: 25px;
      margin-top: 20px;
    }

    /* Treatment Card */
    .treatment-card {
      background: white;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 4px 15px rgba(93, 64, 55, 0.08);
      border: 1px solid #e8d7c9;
      transition: all 0.3s ease;
      display: flex;
      flex-direction: column;
    }

    .treatment-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 25px rgba(93, 64, 55, 0.15);
      border-color: #a1887f;
    }

    /* Card Image */
    .card-image {
      width: 100%;
      height: 200px;
      overflow: hidden;
    }

    .card-image img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.5s ease;
    }

    .treatment-card:hover .card-image img {
      transform: scale(1.05);
    }

    /* Card Content */
    .card-content {
      padding: 25px;
      flex: 1;
      display: flex;
      flex-direction: column;
    }

    .treatment-name {
      font-size: 18px;
      font-weight: 600;
      color: #5d4037;
      margin-bottom: 15px;
      line-height: 1.4;
    }

    .treatment-price {
      color: #8d6e63;
      font-size: 20px;
      font-weight: 700;
      margin: 15px 0;
      padding: 10px 0;
      border-top: 1px solid #f0e6e0;
      border-bottom: 1px solid #f0e6e0;
    }

    .treatment-desc {
      color: #795548;
      line-height: 1.6;
      margin: 10px 0 20px;
      flex: 1;
      font-size: 14px;
    }

    /* Reserve Button */
    .reserve-btn {
      display: block;
      text-align: center;
      background: white;
      color: #333;
      text-decoration: none;
      padding: 14px 20px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 15px;
      transition: all 0.3s ease;
      border: 2px solid #e0e0e0;
      margin-top: auto;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15),
                  0 1px 3px rgba(0, 0, 0, 0.2) inset;
      cursor: pointer;
      position: relative;
      overflow: hidden;
    }

    .reserve-btn:hover {
      background: #f8f9fa;
      transform: translateY(-3px);
      box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2),
                  0 2px 4px rgba(0, 0, 0, 0.1) inset;
      border-color: #a1887f;
      color: #a1887f;
    }

    .reserve-btn:active {
      transform: translateY(-1px);
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.15),
                  0 1px 2px rgba(0, 0, 0, 0.1) inset;
    }

    .reserve-btn i {
      margin-right: 8px;
      color: #a1887f;
      transition: all 0.3s ease;
    }

    .reserve-btn:hover i {
      color: #8a5726;
      transform: scale(1.1);
    }

    /* Empty state */
    .empty-state {
      text-align: center;
      padding: 60px 20px;
      background: white;
      border-radius: 12px;
      border: 2px dashed #e0d5cc;
      margin: 40px auto;
      max-width: 600px;
    }

    .empty-state i {
      font-size: 48px;
      color: #d7ccc8;
      margin-bottom: 20px;
    }

    .empty-state h3 {
      color: #8d6e63;
      margin-bottom: 10px;
      font-weight: 500;
    }

    .empty-state p {
      color: #a1887f;
    }

    /* Error message */
    .error-message {
      text-align: center;
      padding: 20px;
      background: white;
      border-radius: 8px;
      border: 1px solid #f5c6cb;
      color: #721c24;
      margin: 20px auto;
      max-width: 600px;
    }

    /* Footer */
    .footer {
      text-align: center;
      padding: 30px 20px;
      background: white;
      border-top: 1px solid #e8d7c9;
      color: #8d6e63;
      font-size: 14px;
      margin-top: 40px;
    }

    .footer strong {
      color: #5d4037;
      display: block;
      margin-bottom: 8px;
      font-size: 15px;
    }

    /* ================= WHATSAPP FLOAT ================= */
    .whatsapp-float {
        position: fixed;
        width: 56px;
        height: 56px;
        bottom: 30px;
        right: 30px;
        background-color: #25d366;
        color: #FFF;
        border-radius: 50%;
        text-align: center;
        font-size: 26px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.2);
        z-index: 100;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        transition: all 0.3s ease;
    }

    .whatsapp-float:hover {
        background-color: #128C7E;
        transform: scale(1.08);
        box-shadow: 0 5px 15px rgba(0,0,0,0.3);
    }

    /* ================= RESPONSIVE DESIGN ================= */

    /* Tablet (768px - 1024px) */
    @media (max-width: 1024px) {
      .treatment-grid {
        gap: 20px;
      }
    }

    /* Tablet Kecil (768px dan di bawah) */
    @media (max-width: 768px) {
      .main-content {
        padding: 20px;
      }
      
      .header {
        padding: 30px 20px;
      }
      
      .header h1 {
        font-size: 24px;
        padding-right: 50px;
      }
      
      /* Sembunyikan navbar desktop, tampilkan hamburger */
      .nav-desktop {
        display: none;
      }
      
      .hamburger-btn {
        display: flex;
      }
      
      .treatment-grid {
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 15px;
      }
      
      .whatsapp-float {
        width: 50px;
        height: 50px;
        bottom: 25px;
        right: 25px;
        font-size: 24px;
      }
    }

    /* HP (480px - 600px) */
    @media (max-width: 600px) {
      .treatment-grid {
        grid-template-columns: 1fr;
        max-width: 400px;
        margin-left: auto;
        margin-right: auto;
      }
      
      .header h1 {
        font-size: 1.8em;
        padding-right: 45px;
      }
      
      .hamburger-btn {
        top: 25px;
        width: 40px;
        height: 40px;
      }
      
      .hamburger-btn span {
        width: 18px;
        height: 1.8px;
      }
      
      .mobile-nav {
        width: 240px;
        padding: 65px 15px 15px;
      }
      
      .mobile-nav a {
        padding: 10px 14px;
        font-size: 13px;
      }
      
      .close-menu {
        width: 32px;
        height: 32px;
        font-size: 16px;
      }
      
      .card-content {
        padding: 20px;
      }
      
      .treatment-name {
        font-size: 16px;
      }
      
      .treatment-price {
        font-size: 18px;
      }
      
      .whatsapp-float {
        width: 46px;
        height: 46px;
        bottom: 20px;
        right: 20px;
        font-size: 22px;
      }
    }

    /* HP Kecil (di bawah 480px) */
    @media (max-width: 480px) {
      .container {
        padding: 0;
      }
      
      .main-content {
        padding: 15px;
      }
      
      .header {
        padding: 25px 15px;
      }
      
      .header h1 {
        font-size: 1.6em;
        padding-right: 40px;
      }
      
      .header p {
        font-size: 14px;
      }
      
      .hamburger-btn {
        top: 22px;
        right: 15px;
        width: 36px;
        height: 36px;
      }
      
      .hamburger-btn span {
        width: 16px;
        height: 1.5px;
      }
      
      .mobile-nav {
        width: 220px;
        padding: 60px 12px 12px;
      }
      
      .treatment-grid {
        gap: 12px;
      }
      
      .whatsapp-float {
        width: 42px;
        height: 42px;
        bottom: 18px;
        right: 18px;
        font-size: 20px;
      }
    }

    /* Animations */
    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(10px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .treatment-card {
      animation: fadeIn 0.5s ease-out;
      animation-fill-mode: both;
    }

    .treatment-card:nth-child(1) { animation-delay: 0.1s; }
    .treatment-card:nth-child(2) { animation-delay: 0.2s; }
    .treatment-card:nth-child(3) { animation-delay: 0.3s; }
    .treatment-card:nth-child(4) { animation-delay: 0.4s; }
    .treatment-card:nth-child(5) { animation-delay: 0.5s; }
    .treatment-card:nth-child(6) { animation-delay: 0.6s; }
    .treatment-card:nth-child(7) { animation-delay: 0.7s; }
    .treatment-card:nth-child(8) { animation-delay: 0.8s; }
    .treatment-card:nth-child(9) { animation-delay: 0.9s; }
    .treatment-card:nth-child(10) { animation-delay: 1.0s; }

    /* Scrollbar */
    ::-webkit-scrollbar {
      width: 8px;
    }

    ::-webkit-scrollbar-track {
      background: #f5efeb;
    }

    ::-webkit-scrollbar-thumb {
      background: #8d6e63;
      border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
      background: #7b5b52;
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Header -->
    <div class="header">
      <h1>Daftar Treatment</h1>
      <p>Pilih treatment terbaik untuk perawatan kecantikan Anda</p>
      
      <!-- Hamburger Button untuk Mobile -->
      <button class="hamburger-btn" id="hamburgerBtn">
        <span></span>
        <span></span>
        <span></span>
      </button>
    </div>

    <!-- Desktop Navigation -->
    <div class="nav-desktop">
      <a href="home.php">Home</a>
      <a href="treatment.php" class="active">Treatment</a>
      <a href="rekomendasi.php">Rekomendasi</a>
      <a href="testimoni.php">Testimoni</a>
      <a href="konsultasi.php">Konsultasi</a>
    </div>

    <!-- Mobile Navigation Overlay & Menu -->
    <div class="mobile-nav-container">
        <div class="mobile-nav-overlay" id="mobileOverlay"></div>
        <nav class="mobile-nav" id="mobileNav">
            <button class="close-menu" id="closeMenu">×</button>
            <a href="home.php">Home</a>
            <a href="treatment.php" class="active">Treatment</a>
            <a href="rekomendasi.php">Rekomendasi</a>
            <a href="testimoni.php">Testimoni</a>
            <a href="konsultasi.php">Konsultasi</a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
      <?php if (isset($_GET['pesan'])): ?>
        <div class="alert">
          <?php echo htmlspecialchars($_GET['pesan']); ?>
        </div>
      <?php endif; ?>

      <div class="grid-container">
        <div class="treatment-grid">
          <?php
          // Jalankan query
          $q = mysqli_query($conn, "SELECT * FROM treatment");

          // Cek jika query gagal
          if (!$q) {
              echo '<div class="error-message">
                      <i class="fas fa-exclamation-circle"></i> 
                      Query gagal: ' . htmlspecialchars(mysqli_error($conn)) . '
                    </div>';
          } else {
              // Jika query berhasil tapi tabel kosong
              if (mysqli_num_rows($q) == 0) {
                  echo '<div class="empty-state">
                          <i class="fas fa-spa"></i>
                          <h3>Belum ada treatment tersedia</h3>
                          <p>Treatment akan segera ditambahkan</p>
                        </div>';
              } else {
                  // Loop data treatment
                  while ($r = mysqli_fetch_assoc($q)):
                      // Cegah error kalau kolom tidak ada
                      $image = isset($r['image']) && $r['image'] != '' ? $r['image'] : 'placeholder.png';
                      $nama = isset($r['nama']) ? $r['nama'] : 'Nama tidak tersedia';
                      $harga = isset($r['harga']) ? $r['harga'] : 0;
                      $keterangan = isset($r['keterangan']) ? $r['keterangan'] : 'Belum ada deskripsi';
          ?>
            <div class="treatment-card">
              <div class="card-image">
                <img src="images/<?php echo htmlspecialchars($image); ?>" 
                     alt="<?php echo htmlspecialchars($nama); ?>" 
                     onerror="this.src='images/placeholder.png'">
              </div>
              <div class="card-content">
                <h3 class="treatment-name"><?php echo htmlspecialchars($nama); ?></h3>
                <div class="treatment-price">
                  Rp <?php echo number_format($harga, 0, ',', '.'); ?>
                </div>
                <p class="treatment-desc">
                  <?php 
                  $short_desc = htmlspecialchars(substr($keterangan, 0, 120));
                  echo $short_desc . (strlen($keterangan) > 120 ? '...' : '');
                  ?>
                </p>
                <a class="reserve-btn" href="reservasi.php?tid=<?php echo $r['id']; ?>">
                  <i class="fas fa-calendar-check"></i> Reservasi Sekarang
                </a>
              </div>
            </div>
          <?php
                  endwhile;
              }
          }
          ?>
        </div>
      </div>
    </div>

    <!-- Footer -->
    <div class="footer">
      <strong>&copy; <?php echo date('Y'); ?> Mahera Beauty</strong>
      <p>Tempat terbaik untuk perawatan kecantikan Anda</p>
    </div>
  </div>

  <script>
    // JavaScript untuk hamburger menu
    const hamburgerBtn = document.getElementById('hamburgerBtn');
    const closeMenu = document.getElementById('closeMenu');
    const mobileNav = document.getElementById('mobileNav');
    const mobileOverlay = document.getElementById('mobileOverlay');
    
    hamburgerBtn.addEventListener('click', () => {
        mobileNav.classList.add('active');
        mobileOverlay.classList.add('active');
        document.body.style.overflow = 'hidden';
    });
    
    closeMenu.addEventListener('click', () => {
        mobileNav.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.style.overflow = 'auto';
    });
    
    mobileOverlay.addEventListener('click', () => {
        mobileNav.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.style.overflow = 'auto';
    });
    
    const mobileLinks = document.querySelectorAll('.mobile-nav a');
    mobileLinks.forEach(link => {
        link.addEventListener('click', () => {
            mobileNav.classList.remove('active');
            mobileOverlay.classList.remove('active');
            document.body.style.overflow = 'auto';
        });
    });
    
    // Close menu dengan ESC key
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            mobileNav.classList.remove('active');
            mobileOverlay.classList.remove('active');
            document.body.style.overflow = 'auto';
        }
    });

    // Highlight menu aktif berdasarkan halaman
    document.addEventListener('DOMContentLoaded', function() {
      const currentPage = window.location.pathname.split('/').pop();
      const desktopLinks = document.querySelectorAll('.nav-desktop a');
      const mobileLinks = document.querySelectorAll('.mobile-nav a');
      
      desktopLinks.forEach(link => {
        const linkPage = link.getAttribute('href');
        if (linkPage === currentPage) {
          link.classList.add('active');
        }
      });
      
      mobileLinks.forEach(link => {
        const linkPage = link.getAttribute('href');
        if (linkPage === currentPage) {
          link.classList.add('active');
        }
      });
      
      // Tambahkan delay animasi untuk setiap card
      const cards = document.querySelectorAll('.treatment-card');
      cards.forEach((card, index) => {
        card.style.animationDelay = (index * 0.1) + 's';
      });
    });
  </script>
</body>
</html>