<?php 
session_start();
include 'koneksi.php';

// Error handling untuk koneksi database
if (!$conn) {
    die("Koneksi database gagal: " . mysqli_connect_error());
}

// Deteksi struktur tabel
$query_check_columns = "SHOW COLUMNS FROM testimoni";
$result_columns = mysqli_query($conn, $query_check_columns);
$has_rating = false;
$has_treatment = false;

while ($column = mysqli_fetch_assoc($result_columns)) {
    if ($column['Field'] == 'rating') $has_rating = true;
    if ($column['Field'] == 'treatment') $has_treatment = true;
}

// PHP code untuk menangani form testimoni
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['nama'])) {
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $testimoni = mysqli_real_escape_string($conn, $_POST['testimoni']);
    $rating = isset($_POST['rating']) ? intval($_POST['rating']) : 0;
    $treatment = isset($_POST['treatment']) ? mysqli_real_escape_string($conn, $_POST['treatment']) : '';
    
    // Validasi input
    if (!empty($nama) && !empty($testimoni)) {
        // Bangun query berdasarkan kolom yang tersedia
        $columns = "nama, pesan, approved";
        $values = "'$nama', '$testimoni', 0";
        
        if ($has_rating && $rating > 0) {
            $columns .= ", rating";
            $values .= ", $rating";
        }
        
        if ($has_treatment && !empty($treatment)) {
            $columns .= ", treatment";
            $values .= ", '$treatment'";
        }
        
        $query = "INSERT INTO testimoni ($columns) VALUES ($values)";
        
        if (mysqli_query($conn, $query)) {
            $_SESSION['flash_message'] = "Terima kasih! Testimoni Anda telah dikirim dan menunggu verifikasi admin.";
            $_SESSION['flash_type'] = "success";
            header("Location: testimoni.php");
            exit();
        } else {
            $_SESSION['flash_message'] = "Maaf, terjadi kesalahan sistem. Silakan coba lagi. Error: " . mysqli_error($conn);
            $_SESSION['flash_type'] = "error";
        }
    } else {
        $_SESSION['flash_message'] = "Harap lengkapi nama dan testimoni!";
        $_SESSION['flash_type'] = "error";
    }
    
    header("Location: testimoni.php");
    exit();
}

// Ambil testimoni yang sudah disetujui (approved = 1)
$query_testimoni = "SELECT * FROM testimoni WHERE approved = 1 ORDER BY id DESC";
$testimoni_verified = mysqli_query($conn, $query_testimoni);

// Cek jika query gagal
if (!$testimoni_verified) {
    $_SESSION['flash_message'] = "Error: Gagal mengambil data testimoni.";
    $_SESSION['flash_type'] = "error";
    $testimoni_verified = false;
}

// Daftar treatment yang tersedia
$treatments = [
    "Facial Brightening",
    "Facial Anti-Aging", 
    "Facial Detox",
    "Facial Anti-Acne",
    "Facial Hydrating"
];
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Testimoni - Mahera Beauty</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    /* Reset dan variabel warna coklat tipis */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
      background: #faf8f5;
      color: #5d4037;
      line-height: 1.6;
      min-height: 100vh;
      padding: 20px;
    }

    .container {
      max-width: 1200px;
      margin: 0 auto;
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(93, 64, 55, 0.08);
      padding: 30px;
      border: 1px solid #e8d7c9;
      position: relative;
    }

    /* Header */
    .header {
      text-align: center;
      margin-bottom: 30px;
      padding-bottom: 20px;
      border-bottom: 2px solid #d7ccc8;
      position: relative;
    }

    .header h1 {
      font-size: 28px;
      font-weight: 600;
      color: #5d4037;
      padding-right: 60px;
    }

    /* ================= HAMBURGER MENU ================= */
    .hamburger-btn {
        display: none;
        position: absolute;
        top: 0;
        right: 0;
        background: #8d6e63;
        border: none;
        width: 44px;
        height: 44px;
        border-radius: 8px;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        cursor: pointer;
        z-index: 1001;
        box-shadow: 0 2px 8px rgba(141, 110, 99, 0.3);
        transition: all 0.3s ease;
    }

    .hamburger-btn:hover {
        transform: scale(1.05);
        box-shadow: 0 4px 12px rgba(141, 110, 99, 0.4);
    }

    .hamburger-btn span {
        display: block;
        width: 20px;
        height: 2px;
        background: white;
        margin: 2px 0;
        border-radius: 1px;
        transition: all 0.3s ease;
    }

    /* Mobile Menu Overlay */
    .mobile-nav-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 999;
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .mobile-nav-overlay.active {
        display: block;
        opacity: 1;
    }

    /* Mobile Menu Sidebar */
    .mobile-nav {
        position: fixed;
        top: 0;
        right: -280px;
        width: 260px;
        height: 100%;
        background: #fffbf8;
        z-index: 1000;
        padding: 70px 20px 20px;
        box-shadow: -3px 0 15px rgba(0, 0, 0, 0.15);
        transition: right 0.3s ease;
        overflow-y: auto;
    }

    .mobile-nav.active {
        right: 0;
    }

    .mobile-nav a {
        display: block;
        text-decoration: none;
        background: #8d6e63;
        color: #fff;
        padding: 12px 16px;
        border-radius: 8px;
        margin: 8px 0;
        font-weight: 500;
        text-align: center;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(141, 110, 99, 0.2);
        font-size: 14px;
    }

    .mobile-nav a:hover {
        transform: translateX(-3px);
        background: #a1887f;
        box-shadow: 0 4px 12px rgba(141, 110, 99, 0.3);
    }

    .mobile-nav a.active {
      background: #5d4037;
    }

    /* Close button inside mobile menu */
    .close-menu {
        position: absolute;
        top: 15px;
        right: 15px;
        background: #5d4037;
        color: white;
        border: none;
        width: 36px;
        height: 36px;
        border-radius: 50%;
        font-size: 18px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }

    /* Navigation Desktop */
    .nav-desktop {
      display: flex;
      justify-content: center;
      gap: 12px;
      margin-bottom: 40px;
      flex-wrap: wrap;
    }

    .nav-desktop a {
      padding: 12px 24px;
      text-decoration: none;
      border-radius: 8px;
      font-weight: 500;
      font-size: 14px;
      transition: all 0.3s ease;
      background: white;
      color: #795548;
      border: 1px solid #d7ccc8;
    }

    .nav-desktop a:hover {
      background: #8d6e63;
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(141, 110, 99, 0.2);
    }

    .nav-desktop a.active {
      background: #8d6e63;
      color: white;
      border-color: #8d6e63;
    }

    /* Alert Message */
    .alert {
      background: #f0f7f0;
      border: 1px solid #d4edda;
      color: #155724;
      padding: 15px;
      border-radius: 8px;
      margin-bottom: 25px;
      font-size: 14px;
    }

    .alert.error {
      background: #f8d7da;
      border: 1px solid #f5c6cb;
      color: #721c24;
    }

    /* Testimoni Grid Layout */
    .testimoni-grid {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 30px;
      margin-top: 20px;
    }

    /* Form Card */
    .form-card {
      background: #fffbf8;
      border-radius: 10px;
      padding: 25px;
      border: 1px solid #e0d5cc;
      box-shadow: 0 2px 15px rgba(93, 64, 55, 0.05);
    }

    .form-card h2 {
      font-size: 18px;
      font-weight: 600;
      color: #5d4037;
      margin-bottom: 20px;
      padding-bottom: 10px;
      border-bottom: 1px solid #d7ccc8;
    }

    /* Form Elements */
    .form-group {
      margin-bottom: 20px;
    }

    .form-group label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: #795548;
      font-size: 14px;
    }

    .form-group input,
    .form-group textarea,
    .form-group select {
      width: 100%;
      padding: 12px 15px;
      border: 1px solid #d7ccc8;
      border-radius: 6px;
      font-size: 14px;
      background: white;
      color: #5d4037;
      transition: all 0.3s ease;
      font-family: inherit;
    }

    .form-group textarea {
      min-height: 120px;
      resize: vertical;
    }

    .form-group input:focus,
    .form-group textarea:focus,
    .form-group select:focus {
      outline: none;
      border-color: #a1887f;
      box-shadow: 0 0 0 3px rgba(161, 136, 127, 0.1);
    }

    /* Rating Stars - DIPERBAIKI: dari kanan ke kiri (1-5) */
    .rating-container {
      margin-bottom: 20px;
      <?php if (!$has_rating) echo 'display: none;'; ?>
    }

    .rating-label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: #795548;
      font-size: 14px;
    }

    .rating-stars {
      display: flex;
      flex-direction: row-reverse; /* INI YANG DIPERBAIKI - dari kanan ke kiri */
      justify-content: flex-end; /* Mulai dari kanan */
      gap: 5px;
      margin-bottom: 5px;
    }

    .rating-stars input {
      display: none;
    }

    .rating-stars label {
      font-size: 24px;
      color: #e0d5cc;
      cursor: pointer;
      transition: color 0.2s;
      order: 5; /* Urutan default */
    }

    /* Logika bintang terbalik - hover dan selected dari kanan ke kiri */
    .rating-stars input:checked ~ label {
      color: #ffc107;
    }

    .rating-stars label:hover,
    .rating-stars label:hover ~ label {
      color: #ffc107;
    }

    /* Atur urutan label untuk tampilan visual */
    .rating-stars label[for="star1"] { order: 5; }
    .rating-stars label[for="star2"] { order: 4; }
    .rating-stars label[for="star3"] { order: 3; }
    .rating-stars label[for="star4"] { order: 2; }
    .rating-stars label[for="star5"] { order: 1; }

    .rating-value {
      font-size: 13px;
      color: #8d6e63;
      margin-top: 5px;
    }

    /* Submit Button */
    .submit-btn {
      background: #8d6e63;
      color: white;
      border: none;
      padding: 12px 25px;
      border-radius: 6px;
      font-size: 15px;
      font-weight: 600;
      cursor: pointer;
      width: 100%;
      transition: all 0.3s ease;
    }

    .submit-btn:hover {
      background: #7b5b52;
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(141, 110, 99, 0.2);
    }

    /* Testimoni List Card */
    .list-card {
      background: #fffbf8;
      border-radius: 10px;
      padding: 25px;
      border: 1px solid #e0d5cc;
      box-shadow: 0 2px 15px rgba(93, 64, 55, 0.05);
    }

    .list-card h2 {
      font-size: 18px;
      font-weight: 600;
      color: #5d4037;
      margin-bottom: 20px;
      padding-bottom: 10px;
      border-bottom: 1px solid #d7ccc8;
    }

    /* Testimoni Items */
    .testimoni-item {
      background: white;
      border-radius: 8px;
      padding: 20px;
      margin-bottom: 15px;
      border: 1px solid #f0e6e0;
      transition: all 0.3s ease;
    }

    .testimoni-item:hover {
      border-color: #a1887f;
      box-shadow: 0 4px 12px rgba(141, 110, 99, 0.1);
    }

    .testimoni-author {
      font-weight: 600;
      color: #5d4037;
      margin-bottom: 10px;
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .verified-badge {
      background: #4caf50;
      color: white;
      font-size: 11px;
      padding: 2px 8px;
      border-radius: 10px;
      font-weight: 500;
    }

    /* Display Rating */
    .display-rating {
      display: flex;
      align-items: center;
      gap: 8px;
      margin-bottom: 10px;
    }

    .display-stars {
      display: flex;
      gap: 2px;
    }

    .display-stars .star {
      color: #ffc107;
      font-size: 16px;
    }

    .display-stars .star.empty {
      color: #e0d5cc;
    }

    /* Treatment Badge */
    .treatment-badge {
      display: inline-block;
      background: #f5efeb;
      color: #795548;
      font-size: 12px;
      padding: 4px 10px;
      border-radius: 12px;
      margin-bottom: 10px;
      border: 1px solid #d7ccc8;
    }

    .testimoni-text {
      color: #5d4037;
      line-height: 1.6;
      font-size: 14px;
    }

    /* No Testimoni Message */
    .no-testimoni {
      text-align: center;
      padding: 40px 20px;
      color: #8d6e63;
      font-style: italic;
      background: white;
      border-radius: 8px;
      border: 1px dashed #d7ccc8;
    }

    /* Footer */
    .footer {
      text-align: center;
      margin-top: 40px;
      padding-top: 20px;
      border-top: 1px solid #e0d5cc;
      color: #8d6e63;
      font-size: 13px;
    }

    /* ================= WHATSAPP FLOAT ================= */
    .whatsapp-float {
        position: fixed;
        width: 56px;
        height: 56px;
        bottom: 30px;
        right: 30px;
        background-color: #25d366;
        color: #FFF;
        border-radius: 50%;
        text-align: center;
        font-size: 26px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.2);
        z-index: 100;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        transition: all 0.3s ease;
    }

    .whatsapp-float:hover {
        background-color: #128C7E;
        transform: scale(1.08);
        box-shadow: 0 5px 15px rgba(0,0,0,0.3);
    }

    /* ================= RESPONSIVE DESIGN ================= */

    /* Tablet (768px - 1024px) */
    @media (max-width: 1024px) {
      .testimoni-grid {
        gap: 25px;
      }
    }

    /* Tablet Kecil (768px dan di bawah) */
    @media (max-width: 768px) {
      .container {
        padding: 20px;
      }

      /* Sembunyikan navbar desktop, tampilkan hamburger */
      .nav-desktop {
        display: none;
      }
      
      .hamburger-btn {
        display: flex;
      }
      
      .header h1 {
        font-size: 24px;
        padding-right: 50px;
      }

      .testimoni-grid {
        grid-template-columns: 1fr;
        gap: 20px;
      }

      .form-card,
      .list-card {
        padding: 20px;
      }

      .testimoni-item {
        padding: 15px;
      }

      .rating-stars label {
        font-size: 20px;
      }
      
      .whatsapp-float {
        width: 50px;
        height: 50px;
        bottom: 25px;
        right: 25px;
        font-size: 24px;
      }
    }

    /* HP (480px - 600px) */
    @media (max-width: 600px) {
      body {
        padding: 10px;
      }
      
      .container {
        padding: 15px;
      }
      
      .header h1 {
        font-size: 1.8em;
        padding-right: 45px;
      }
      
      .hamburger-btn {
        width: 40px;
        height: 40px;
      }
      
      .hamburger-btn span {
        width: 18px;
        height: 1.8px;
      }
      
      .mobile-nav {
        width: 240px;
        padding: 65px 15px 15px;
      }
      
      .mobile-nav a {
        padding: 10px 14px;
        font-size: 13px;
      }
      
      .close-menu {
        width: 32px;
        height: 32px;
        font-size: 16px;
      }
      
      .form-card h2,
      .list-card h2 {
        font-size: 16px;
      }
      
      .rating-stars label {
        font-size: 18px;
      }
      
      .display-stars .star {
        font-size: 14px;
      }
      
      .whatsapp-float {
        width: 46px;
        height: 46px;
        bottom: 20px;
        right: 20px;
        font-size: 22px;
      }
    }

    /* HP Kecil (di bawah 480px) */
    @media (max-width: 480px) {
      .container {
        padding: 12px;
      }

      .header h1 {
        font-size: 1.6em;
        padding-right: 40px;
      }
      
      .hamburger-btn {
        width: 36px;
        height: 36px;
      }
      
      .hamburger-btn span {
        width: 16px;
        height: 1.5px;
      }
      
      .mobile-nav {
        width: 220px;
        padding: 60px 12px 12px;
      }
      
      .form-card,
      .list-card {
        padding: 16px;
      }
      
      .rating-stars label {
        font-size: 16px;
      }
      
      .display-stars .star {
        font-size: 13px;
      }
      
      .whatsapp-float {
        width: 42px;
        height: 42px;
        bottom: 18px;
        right: 18px;
        font-size: 20px;
      }
    }

    /* Animations */
    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(10px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .testimoni-item {
      animation: fadeIn 0.5s ease-out;
      animation-fill-mode: both;
    }

    .testimoni-item:nth-child(1) { animation-delay: 0.1s; }
    .testimoni-item:nth-child(2) { animation-delay: 0.2s; }
    .testimoni-item:nth-child(3) { animation-delay: 0.3s; }
    .testimoni-item:nth-child(4) { animation-delay: 0.4s; }
    .testimoni-item:nth-child(5) { animation-delay: 0.5s; }
    .testimoni-item:nth-child(6) { animation-delay: 0.6s; }
    .testimoni-item:nth-child(7) { animation-delay: 0.7s; }
    .testimoni-item:nth-child(8) { animation-delay: 0.8s; }
    .testimoni-item:nth-child(9) { animation-delay: 0.9s; }
    .testimoni-item:nth-child(10) { animation-delay: 1.0s; }
  </style>
</head>
<body>
  <div class="container">
    <!-- Header -->
    <div class="header">
      <h1>Testimoni Pelanggan</h1>
      
      <!-- Hamburger Button untuk Mobile -->
      <button class="hamburger-btn" id="hamburgerBtn">
        <span></span>
        <span></span>
        <span></span>
      </button>
    </div>

    <!-- Desktop Navigation -->
    <div class="nav-desktop">
      <a href="home.php">Home</a>
      <a href="treatment.php">Treatment</a>
      <a href="rekomendasi.php">Rekomendasi</a>
      <a href="testimoni.php" class="active">Testimoni</a>
      <a href="konsultasi.php">Konsultasi</a>
    </div>

    <!-- Mobile Navigation Overlay & Menu -->
    <div class="mobile-nav-container">
        <div class="mobile-nav-overlay" id="mobileOverlay"></div>
        <nav class="mobile-nav" id="mobileNav">
            <button class="close-menu" id="closeMenu">×</button>
            <a href="home.php">Home</a>
            <a href="treatment.php">Treatment</a>
            <a href="rekomendasi.php">Rekomendasi</a>
            <a href="testimoni.php" class="active">Testimoni</a>
            <a href="konsultasi.php">Konsultasi</a>
        </nav>
    </div>

    <!-- Flash Messages -->
    <?php if (isset($_SESSION['flash_message'])): ?>
      <div class="alert <?php echo $_SESSION['flash_type'] == 'error' ? 'error' : ''; ?>">
        <?php echo htmlspecialchars($_SESSION['flash_message']); ?>
      </div>
      <?php 
      unset($_SESSION['flash_message']);
      unset($_SESSION['flash_type']);
      ?>
    <?php endif; ?>

    <div class="testimoni-grid">
      <!-- Form Testimoni -->
      <div class="form-card">
        <h2>Berikan Testimoni Anda</h2>
        <form method="post" autocomplete="off" id="testimoni-form">
          <div class="form-group">
            <input type="text" name="nama" placeholder="Nama Lengkap" required>
          </div>
          
          <?php if ($has_treatment): ?>
          <div class="form-group">
            <label>Treatment yang Digunakan</label>
            <select name="treatment" required>
              <option value="">-- Pilih Treatment --</option>
              <?php foreach($treatments as $treatment): ?>
                <option value="<?php echo $treatment; ?>"><?php echo $treatment; ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <?php endif; ?>
          
          <?php if ($has_rating): ?>
          <div class="rating-container">
            <label class="rating-label">Rating Treatment</label>
            <div class="rating-stars" id="rating-stars">
              <!-- URUTAN DARI KANAN KE KIRI: star1 (rating 1) paling kanan -->
              <input type="radio" id="star1" name="rating" value="1">
              <label for="star1">★</label>
              <input type="radio" id="star2" name="rating" value="2">
              <label for="star2">★</label>
              <input type="radio" id="star3" name="rating" value="3">
              <label for="star3">★</label>
              <input type="radio" id="star4" name="rating" value="4">
              <label for="star4">★</label>
              <input type="radio" id="star5" name="rating" value="5">
              <label for="star5">★</label>
            </div>
            <div class="rating-value" id="rating-value">Pilih rating</div>
          </div>
          <?php endif; ?>
          
          <div class="form-group">
            <label>Testimoni Anda</label>
            <textarea name="testimoni" placeholder="Ceritakan pengalaman Anda dengan treatment kami..." required></textarea>
          </div>
          
          <button type="submit" class="submit-btn">
            <i class="fas fa-paper-plane"></i> Kirim Testimoni
          </button>
        </form>
      </div>

      <!-- Daftar Testimoni -->
      <div class="list-card">
        <h2>Testimoni Pelanggan</h2>
        
        <?php if ($testimoni_verified && mysqli_num_rows($testimoni_verified) > 0): ?>
          <?php while($row = mysqli_fetch_assoc($testimoni_verified)): ?>
            <div class="testimoni-item">
              <div class="testimoni-author">
                <?php echo htmlspecialchars($row['nama']); ?>
                <span class="verified-badge">✓ Terverifikasi</span>
              </div>
              
              <?php if ($has_treatment && !empty($row['treatment'])): ?>
                <div class="treatment-badge">
                  <?php echo htmlspecialchars($row['treatment']); ?>
                </div>
              <?php endif; ?>
              
              <?php if ($has_rating && !empty($row['rating'])): ?>
                <div class="display-rating">
                  <div class="display-stars">
                    <?php
                    $rating = intval($row['rating']);
                    for ($i = 1; $i <= 5; $i++) {
                      if ($i <= $rating) {
                        echo '<span class="star">★</span>';
                      } else {
                        echo '<span class="star empty">★</span>';
                      }
                    }
                    ?>
                  </div>
                  <span><?php echo $rating; ?>/5</span>
                </div>
              <?php endif; ?>
              
              <div class="testimoni-text">
                "<?php echo nl2br(htmlspecialchars($row['pesan'])); ?>"
              </div>
            </div>
          <?php endwhile; ?>
        <?php else: ?>
          <div class="no-testimoni">
            <i class="fas fa-comment-slash" style="font-size: 48px; margin-bottom: 15px; color: #d7ccc8;"></i>
            <p>Belum ada testimoni yang tersedia. Jadilah yang pertama memberikan testimoni!</p>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Footer -->
    <div class="footer">
      <p>© <?php echo date('Y'); ?> Mahera Beauty. Semua testimoni telah diverifikasi oleh admin.</p>
      <p>Testimoni akan tampil setelah disetujui oleh tim kami.</p>
    </div>
  </div>



  <!-- JavaScript -->
  <script>
    // Mobile Menu Toggle
    const hamburgerBtn = document.getElementById('hamburgerBtn');
    const closeMenu = document.getElementById('closeMenu');
    const mobileNav = document.getElementById('mobileNav');
    const mobileOverlay = document.getElementById('mobileOverlay');

    hamburgerBtn.addEventListener('click', () => {
      mobileNav.classList.add('active');
      mobileOverlay.classList.add('active');
      document.body.style.overflow = 'hidden';
    });

    closeMenu.addEventListener('click', () => {
      mobileNav.classList.remove('active');
      mobileOverlay.classList.remove('active');
      document.body.style.overflow = 'auto';
    });

    mobileOverlay.addEventListener('click', () => {
      mobileNav.classList.remove('active');
      mobileOverlay.classList.remove('active');
      document.body.style.overflow = 'auto';
    });

    // Rating Stars Interaction
    const ratingStars = document.querySelectorAll('#rating-stars input');
    const ratingValue = document.getElementById('rating-value');
    
    if (ratingStars.length > 0) {
      ratingStars.forEach(star => {
        star.addEventListener('change', function() {
          const value = this.value;
          const labels = {
            1: "Tidak Puas",
            2: "Kurang Puas", 
            3: "Cukup Puas",
            4: "Puas",
            5: "Sangat Puas"
          };
          ratingValue.textContent = `${value} bintang - ${labels[value]}`;
        });
      });
    }

    // Form Submission Confirmation
    const form = document.getElementById('testimoni-form');
    if (form) {
      form.addEventListener('submit', function(e) {
        const nama = this.nama.value.trim();
        const testimoni = this.testimoni.value.trim();
        
        if (!nama || !testimoni) {
          e.preventDefault();
          alert('Harap lengkapi nama dan testimoni!');
          return;
        }
        
        // Jika ada rating, validasi
        const ratingInputs = this.querySelectorAll('input[name="rating"]:checked');
        if (this.querySelector('.rating-container') && this.querySelector('.rating-container').style.display !== 'none' && ratingInputs.length === 0) {
          if (!confirm('Anda belum memilih rating. Lanjutkan tanpa rating?')) {
            e.preventDefault();
            return;
          }
        }
        
        // Jika ada treatment, validasi
        const treatmentSelect = this.querySelector('select[name="treatment"]');
        if (treatmentSelect && !treatmentSelect.value) {
          if (!confirm('Anda belum memilih treatment. Lanjutkan tanpa treatment?')) {
            e.preventDefault();
            return;
          }
        }
      });
    }

    // Close mobile menu on escape key
    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape') {
        mobileNav.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.style.overflow = 'auto';
      }
    });
  </script>
</body>
</html>
<?php mysqli_close($conn); ?>