<?php
include 'koneksi.php';

// Ambil data treatment jika ada parameter tid
$selectedTreatment = "";
if (isset($_GET['tid'])) {
    $tid = mysqli_real_escape_string($conn, $_GET['tid']);
    $treatmentQuery = mysqli_query($conn, "SELECT * FROM treatment WHERE id = '$tid'");
    if ($treatmentQuery && mysqli_num_rows($treatmentQuery) > 0) {
        $treatmentData = mysqli_fetch_assoc($treatmentQuery);
        $selectedTreatment = $treatmentData['nama'];
    }
}

if (isset($_POST['submit'])) {
    // Gunakan isset() untuk mencegah error undefined array key
    $nama = isset($_POST['nama_lengkap']) ? mysqli_real_escape_string($conn, $_POST['nama_lengkap']) : '';
    $hp = isset($_POST['no_hp']) ? mysqli_real_escape_string($conn, $_POST['no_hp']) : '';
    $layanan = isset($_POST['layanan']) ? mysqli_real_escape_string($conn, $_POST['layanan']) : '';
    $tanggal = isset($_POST['tanggal']) ? mysqli_real_escape_string($conn, $_POST['tanggal']) : '';
    $jam = isset($_POST['jam']) ? mysqli_real_escape_string($conn, $_POST['jam']) : '';
    $catatan = isset($_POST['catatan']) ? mysqli_real_escape_string($conn, $_POST['catatan']) : '';

    // Validasi field wajib
    if (empty($nama) || empty($hp) || empty($layanan) || empty($tanggal) || empty($jam)) {
        echo "<script>alert('Semua field wajib diisi!'); window.history.back();</script>";
        exit;
    }

    // Validasi format tanggal
    if (!preg_match('/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/', $tanggal)) {
        echo "<script>alert('Format tanggal harus: dd/mm/yyyy (Contoh: 25/12/2024)'); window.history.back();</script>";
        exit;
    }

    // Validasi format jam
    if (!preg_match('/^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$/', $jam)) {
        echo "<script>alert('Format jam harus: HH:MM (Contoh: 09:30, 14:00, 16:30)'); window.history.back();</script>";
        exit;
    }

    // Format tanggal dari dd/mm/yyyy ke yyyy-mm-dd untuk database
    $tanggalParts = explode('/', $tanggal);
    if (count($tanggalParts) === 3) {
        $day = $tanggalParts[0];
        $month = $tanggalParts[1];
        $year = $tanggalParts[2];
        
        // Validasi apakah tanggal valid
        if (!checkdate($month, $day, $year)) {
            echo "<script>alert('Tanggal tidak valid!'); window.history.back();</script>";
            exit;
        }
        
        $tanggal_db = $year . '-' . $month . '-' . $day;
    } else {
        echo "<script>alert('Format tanggal tidak valid!'); window.history.back();</script>";
        exit;
    }

    // Validasi tanggal tidak boleh dari masa lalu
    $today = date('Y-m-d');
    if ($tanggal_db < $today) {
        echo "<script>alert('Tanggal reservasi tidak boleh dari masa lalu!'); window.history.back();</script>";
        exit;
    }

    // Validasi nomor HP (minimal 10 digit, maksimal 13 digit)
    if (!preg_match('/^[0-9]{10,13}$/', $hp)) {
        echo "<script>alert('Nomor HP harus 10-13 digit angka!'); window.history.back();</script>";
        exit;
    }

    // Insert ke database
    $query = mysqli_query($conn, "
        INSERT INTO reservasi 
        (nama_lengkap, no_hp, layanan, tanggal, jam, catatan, status)
        VALUES 
        ('$nama', '$hp', '$layanan', '$tanggal_db', '$jam', '$catatan', 'pending')
    ");

    if ($query) {
        // Ambil ID reservasi yang baru dibuat
        $reservasi_id = mysqli_insert_id($conn);
        
        echo "<script>
            alert('Reservasi berhasil dibuat!\\\\n\\\\nSilakan kirim bukti transfer via WhatsApp dengan menekan tombol WhatsApp di sebelah.\\\\n\\\\nID Reservasi: R$reservasi_id');
            window.location='reservasi.php';
        </script>";
    } else {
        echo "<script>alert('Gagal membuat reservasi: " . addslashes(mysqli_error($conn)) . "'); window.history.back();</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reservasi Treatment - Mahera Beauty</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, #fff7f0 0%, #f8e9d9 100%);
            padding: 20px;
            color: #4b2e05;
            min-height: 100vh;
            position: relative;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            position: relative;
            z-index: 1;
        }
        
        h2 {
            text-align: center;
            color: #6e3b00;
            margin-bottom: 25px;
            font-size: 28px;
            position: relative;
            padding-bottom: 15px;
        }
        
        h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 3px;
            background: linear-gradient(90deg, #a86b2d, #c49b6c);
            border-radius: 2px;
        }
        
        label {
            font-weight: bold;
            margin-top: 15px;
            display: block;
            color: #5a3a10;
            font-size: 14px;
        }
        
        input, textarea, select {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0d0bb;
            border-radius: 8px;
            margin-top: 8px;
            font-size: 15px;
            transition: all 0.3s ease;
            background: #fefcf9;
        }
        
        input:focus, textarea:focus, select:focus {
            outline: none;
            border-color: #a86b2d;
            background: white;
            box-shadow: 0 0 0 3px rgba(168, 107, 45, 0.1);
        }
        
        .button-group {
            display: flex;
            gap: 15px;
            margin-top: 25px;
        }
        
        .btn-submit {
            flex: 2;
            padding: 15px;
            background: linear-gradient(135deg, #a86b2d 0%, #8a5726 100%);
            color: white;
            border: none;
            font-weight: bold;
            border-radius: 10px;
            cursor: pointer;
            font-size: 16px;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .btn-submit:hover {
            background: linear-gradient(135deg, #8a5726 0%, #6e3b00 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(168, 107, 45, 0.3);
        }
        
        .btn-back {
            flex: 1;
            padding: 15px;
            background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
            color: white;
            border: none;
            font-weight: bold;
            border-radius: 10px;
            cursor: pointer;
            font-size: 16px;
            transition: all 0.3s ease;
            text-decoration: none;
            text-align: center;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .btn-back:hover {
            background: linear-gradient(135deg, #5a6268 0%, #495057 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(108, 117, 125, 0.3);
        }
        
        .rekening-info {
            background: linear-gradient(135deg, #f9f3eb 0%, #f5eade 100%);
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            border-left: 5px solid #a86b2d;
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
        }
        
        .rekening-info h3 {
            margin-top: 0;
            color: #6e3b00;
            font-size: 18px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .rekening-info h3 i {
            color: #a86b2d;
        }
        
        .time-options {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
            margin-top: 10px;
        }
        
        .time-option {
            padding: 12px 8px;
            border: 2px solid #e0d0bb;
            border-radius: 8px;
            text-align: center;
            cursor: pointer;
            background: white;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .time-option:hover {
            background: #f9f3eb;
            border-color: #c49b6c;
        }
        
        .time-option.selected {
            background: #a86b2d;
            color: white;
            border-color: #a86b2d;
            transform: scale(1.05);
        }
        
        .required {
            color: #e74c3c;
        }
        
        /* WhatsApp Button - DIUBAH POSISI DAN UKURAN */
        .whatsapp-btn {
            position: fixed;
            bottom: 30px;
            right: 30px;
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
            color: white;
            border-radius: 50px;
            padding: 15px 25px;
            box-shadow: 0 6px 20px rgba(37, 211, 102, 0.4);
            display: flex;
            align-items: center;
            gap: 12px;
            text-decoration: none;
            font-weight: bold;
            z-index: 1000;
            transition: all 0.3s ease;
            font-size: 16px;
            border: 2px solid white;
        }
        
        .whatsapp-btn:hover {
            transform: scale(1.05) translateY(-5px);
            box-shadow: 0 8px 25px rgba(37, 211, 102, 0.6);
            color: white;
            text-decoration: none;
        }
        
        .whatsapp-icon {
            font-size: 28px;
        }
        
        /* WhatsApp Button di dalam form untuk mobile */
        .whatsapp-form-btn {
            display: none;
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
            color: white;
            border-radius: 10px;
            padding: 15px;
            text-decoration: none;
            font-weight: bold;
            text-align: center;
            margin: 20px 0 10px 0;
            transition: all 0.3s ease;
            border: 2px solid white;
            box-shadow: 0 4px 15px rgba(37, 211, 102, 0.3);
        }
        
        .whatsapp-form-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(37, 211, 102, 0.5);
        }
        
        /* Info Box */
        .info-box {
            background: linear-gradient(135deg, #e8f5e9 0%, #d4edda 100%);
            border: 2px solid #4caf50;
            border-radius: 10px;
            padding: 18px;
            margin: 20px 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .info-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
            background: #4caf50;
        }
        
        .info-box i {
            color: #4caf50;
            font-size: 22px;
            margin-right: 12px;
        }
        
        .info-box strong {
            color: #2e7d32;
            font-size: 16px;
        }
        
        .warning-box {
            background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
            border: 2px solid #ffc107;
            border-radius: 10px;
            padding: 15px;
            margin: 15px 0;
            position: relative;
            overflow: hidden;
        }
        
        .warning-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
            background: #ffc107;
        }
        
        .warning-box i {
            color: #ff9800;
            margin-right: 10px;
            font-size: 18px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .price-display {
            background: #f8f9fa;
            padding: 10px 15px;
            border-radius: 8px;
            margin-top: 10px;
            border-left: 4px solid #a86b2d;
            font-weight: bold;
            color: #6e3b00;
        }
        
        .error-message {
            color: #e74c3c;
            font-size: 12px;
            margin-top: 5px;
            display: none;
        }
        
        .success-message {
            color: #27ae60;
            font-size: 14px;
            margin: 10px 0;
            padding: 10px;
            background: #d4edda;
            border-radius: 5px;
            border-left: 4px solid #27ae60;
        }
        
        @media (max-width: 768px) {
            body {
                padding: 15px;
            }
            
            .container {
                padding: 20px;
            }
            
            .time-options {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .whatsapp-btn {
                bottom: 20px;
                right: 20px;
                padding: 12px 20px;
                font-size: 14px;
            }
            
            .whatsapp-btn span {
                display: none;
            }
            
            .whatsapp-form-btn {
                display: block;
            }
            
            .button-group {
                flex-direction: column;
            }
            
            .btn-submit, .btn-back {
                flex: 1;
                width: 100%;
            }
        }
        
        @media (max-width: 480px) {
            .time-options {
                grid-template-columns: 1fr;
            }
            
            h2 {
                font-size: 24px;
                margin-top: 15px;
            }
            
            .whatsapp-btn {
                padding: 15px;
                border-radius: 50%;
                width: 60px;
                height: 60px;
                justify-content: center;
            }
            
            .whatsapp-btn span {
                display: none;
            }
            
            .whatsapp-icon {
                font-size: 24px;
                margin: 0;
            }
            
            .whatsapp-form-btn {
                display: flex;
                align-items: center;
                justify-content: center;
                gap: 10px;
            }
        }
        
        @media (max-width: 380px) {
            .whatsapp-btn {
                bottom: 15px;
                right: 15px;
                width: 55px;
                height: 55px;
            }
        }
    </style>
</head>
<body>

<!-- WhatsApp Button Floating - TIDAK TERLALU DI POJOK -->
<a href="https://kontakk.com/wa/056e89" 
   class="whatsapp-btn" target="_blank">
   <i class="fab fa-whatsapp whatsapp-icon"></i>
   <span>Kirim Bukti TF</span>
</a>

<div class="container">
    <h2><i class="fas fa-calendar-check"></i> Form Reservasi Treatment</h2>

    <!-- Info Box -->
    <div class="info-box">
        <i class="fas fa-info-circle"></i>
        <strong>Setelah mengisi form, silakan kirim bukti transfer via WhatsApp</strong>
        <br><small>Klik tombol WhatsApp di sebelah kanan bawah</small>
    </div>

    <form method="POST" id="reservasiForm">
        
        <div class="form-group">
            <label>Nama Lengkap <span class="required">*</span></label>
            <input type="text" name="nama_lengkap" placeholder="Nama lengkap" required value="<?php echo isset($_POST['nama_lengkap']) ? htmlspecialchars($_POST['nama_lengkap']) : ''; ?>">
            <div class="error-message" id="namaError"></div>
        </div>

        <div class="form-group">
            <label>No HP / WhatsApp <span class="required">*</span></label>
            <input type="text" name="no_hp" placeholder="Nomor HP/WhatsApp" required value="<?php echo isset($_POST['no_hp']) ? htmlspecialchars($_POST['no_hp']) : ''; ?>">
            <div class="error-message" id="hpError"></div>
        </div>

        <div class="form-group">
            <label>Pilih Layanan <span class="required">*</span></label>
            <select name="layanan" id="layanan" required onchange="updatePrice()">
                <option value="">-- Pilih Layanan Treatment --</option>
                <?php
                // Ambil semua treatment dari database
                $treatmentQuery = mysqli_query($conn, "SELECT * FROM treatment ORDER BY nama");
                while ($treatment = mysqli_fetch_assoc($treatmentQuery)) {
                    $selected = ($treatment['nama'] == $selectedTreatment || (isset($_POST['layanan']) && $_POST['layanan'] == $treatment['nama'])) ? 'selected' : '';
                    echo "<option value='{$treatment['nama']}' data-harga='{$treatment['harga']}' $selected>{$treatment['nama']} - Rp " . number_format($treatment['harga'], 0, ',', '.') . "</option>";
                }
                ?>
            </select>
            <div id="priceDisplay" class="price-display" style="display: none;">
                Harga: Rp <span id="hargaText">0</span>
            </div>
            <div class="error-message" id="layananError"></div>
        </div>

        <div class="form-group">
            <label>Tanggal Reservasi <span class="required">*</span></label>
            <input type="text" name="tanggal" id="tanggalInput" placeholder="dd/mm/yyyy" required value="<?php echo isset($_POST['tanggal']) ? htmlspecialchars($_POST['tanggal']) : ''; ?>">
            <div class="error-message" id="tanggalError"></div>
        </div>

        <div class="form-group">
            <label>Jam Reservasi <span class="required">*</span></label>
            <input type="text" name="jam" id="jamInput" placeholder="HH:MM" required value="<?php echo isset($_POST['jam']) ? htmlspecialchars($_POST['jam']) : ''; ?>">
            <div class="error-message" id="jamError"></div>
            
            <!-- Opsi jam cepat -->
            <div class="time-options">
                <div class="time-option" onclick="selectTime('09:00')">09:00</div>
                <div class="time-option" onclick="selectTime('10:00')">10:00</div>
                <div class="time-option" onclick="selectTime('11:00')">11:00</div>
                <div class="time-option" onclick="selectTime('13:00')">13:00</div>
                <div class="time-option" onclick="selectTime('14:00')">14:00</div>
                <div class="time-option" onclick="selectTime('15:00')">15:00</div>
                <div class="time-option" onclick="selectTime('16:00')">16:00</div>
                <div class="time-option" onclick="selectTime('17:00')">17:00</div>
                <div class="time-option" onclick="selectTime('18:00')">18:00</div>
            </div>
        </div>

        <div class="form-group">
            <label>Catatan (opsional)</label>
            <textarea name="catatan" rows="3" placeholder="Catatan tambahan untuk treatment"><?php echo isset($_POST['catatan']) ? htmlspecialchars($_POST['catatan']) : ''; ?></textarea>
        </div>

        <div class="rekening-info">
            <h3><i class="fas fa-credit-card"></i> Informasi Pembayaran</h3>
            <p><strong>Transfer ke Rekening:</strong></p>
            <p>🏦 Bank BCA: <strong>1234567890</strong> (a.n Mahera Beauty)</p>
            <p>🏦 Bank Mandiri: <strong>0987654321</strong> (a.n Mahera Beauty)</p>
            <p>🏦 Bank BRI: <strong>1122334455</strong> (a.n Mahera Beauty)</p>
            
            <div class="price-display" style="margin: 15px 0;">
                <strong>Total Pembayaran: </strong>
                <span id="totalPembayaran">Pilih layanan terlebih dahulu</span>
            </div>
            
            <!-- Pemberitahuan kirim bukti via WhatsApp -->
            <div class="warning-box">
                <i class="fas fa-exclamation-triangle"></i>
                <strong>PENTING: Konfirmasi Pembayaran</strong>
                <p style="margin: 8px 0 0 0; font-size: 14px;">Setelah mengisi form dan melakukan transfer, silakan kirim bukti transfer via WhatsApp dengan menekan tombol <strong>"Kirim Bukti TF"</strong> di kanan bawah.</p>
            </div>
        </div>

        <!-- WhatsApp Button untuk mobile (di dalam form) -->
        <a href="https://kontakk.com/wa/056e89" 
           class="whatsapp-form-btn" target="_blank">
           <i class="fab fa-whatsapp"></i> Kirim Bukti Transfer via WhatsApp
        </a>

        <!-- BUTTON GROUP: KIRIM dan KEMBALI -->
        <div class="button-group">
            <button type="submit" name="submit" class="btn-submit">
                <i class="fas fa-paper-plane"></i> Kirim Reservasi
            </button>
            
            <a href="treatment.php" class="btn-back">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

    </form>
</div>

<script>
    // Fungsi untuk memilih waktu
    function selectTime(time) {
        document.getElementById('jamInput').value = time;
        document.querySelectorAll('.time-option').forEach(opt => {
            opt.classList.remove('selected');
            if (opt.textContent === time) {
                opt.classList.add('selected');
            }
        });
        hideError('jamError');
    }

    // Fungsi untuk update harga
    function updatePrice() {
        const select = document.getElementById('layanan');
        const selectedOption = select.options[select.selectedIndex];
        const harga = selectedOption.getAttribute('data-harga');
        const priceDisplay = document.getElementById('priceDisplay');
        const totalPembayaran = document.getElementById('totalPembayaran');
        
        if (harga) {
            const hargaFormatted = new Intl.NumberFormat('id-ID').format(harga);
            document.getElementById('hargaText').textContent = hargaFormatted;
            priceDisplay.style.display = 'block';
            totalPembayaran.innerHTML = `<strong style="color: #e74c3c; font-size: 18px;">Rp ${hargaFormatted}</strong>`;
            hideError('layananError');
        } else {
            priceDisplay.style.display = 'none';
            totalPembayaran.textContent = 'Pilih layanan terlebih dahulu';
        }
    }

    // Fungsi untuk menampilkan error
    function showError(elementId, message) {
        const errorElement = document.getElementById(elementId);
        errorElement.textContent = message;
        errorElement.style.display = 'block';
    }

    // Fungsi untuk menyembunyikan error
    function hideError(elementId) {
        const errorElement = document.getElementById(elementId);
        errorElement.style.display = 'none';
    }

    // Validasi format tanggal
    document.getElementById('tanggalInput').addEventListener('blur', function() {
        const dateRegex = /^(\d{1,2})\/(\d{1,2})\/(\d{4})$/;
        if (this.value && !dateRegex.test(this.value)) {
            showError('tanggalError', 'Format tanggal harus: dd/mm/yyyy');
        } else {
            hideError('tanggalError');
        }
    });

    // Validasi format jam
    document.getElementById('jamInput').addEventListener('blur', function() {
        const timeRegex = /^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$/;
        if (this.value && !timeRegex.test(this.value)) {
            showError('jamError', 'Format jam harus: HH:MM');
        } else {
            hideError('jamError');
        }
    });

    // Validasi nomor HP
    document.querySelector('input[name="no_hp"]').addEventListener('blur', function() {
        const hpRegex = /^[0-9]{10,13}$/;
        if (this.value && !hpRegex.test(this.value)) {
            showError('hpError', 'Nomor HP harus 10-13 digit angka');
        } else {
            hideError('hpError');
        }
    });

    // Validasi form sebelum submit
    document.getElementById('reservasiForm').addEventListener('submit', function(e) {
        let isValid = true;
        
        // Validasi nama
        const nama = document.querySelector('input[name="nama_lengkap"]').value;
        if (!nama.trim()) {
            showError('namaError', 'Nama lengkap harus diisi');
            isValid = false;
        }
        
        // Validasi nomor HP
        const hp = document.querySelector('input[name="no_hp"]').value;
        const hpRegex = /^[0-9]{10,13}$/;
        if (!hp || !hpRegex.test(hp)) {
            showError('hpError', 'Nomor HP harus 10-13 digit angka');
            isValid = false;
        }
        
        // Validasi layanan
        const layanan = document.getElementById('layanan').value;
        if (!layanan) {
            showError('layananError', 'Silakan pilih layanan treatment');
            isValid = false;
        }
        
        // Validasi tanggal
        const tanggal = document.getElementById('tanggalInput').value;
        const dateRegex = /^(\d{1,2})\/(\d{1,2})\/(\d{4})$/;
        if (!tanggal || !dateRegex.test(tanggal)) {
            showError('tanggalError', 'Format tanggal harus: dd/mm/yyyy');
            isValid = false;
        }
        
        // Validasi jam
        const jam = document.getElementById('jamInput').value;
        const timeRegex = /^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$/;
        if (!jam || !timeRegex.test(jam)) {
            showError('jamError', 'Format jam harus: HH:MM');
            isValid = false;
        }
        
        if (!isValid) {
            e.preventDefault();
            alert('Silakan perbaiki error pada form sebelum mengirim!');
            return;
        }
        
        if (!confirm('PASTIKAN ANDA SUDAH:\n\n1. Melakukan transfer sesuai total pembayaran\n2. Akan mengirim bukti transfer via WhatsApp\n3. Data yang diisi sudah benar\n\nLanjutkan mengirim reservasi?')) {
            e.preventDefault();
        }
    });

    // Initialize price display if treatment is pre-selected
    document.addEventListener('DOMContentLoaded', function() {
        updatePrice();
        
        // Set placeholder dengan tanggal hari ini (format: dd/mm/yyyy)
        const today = new Date();
        const dd = String(today.getDate()).padStart(2, '0');
        const mm = String(today.getMonth() + 1).padStart(2, '0');
        const yyyy = today.getFullYear();
        const todayFormatted = `${dd}/${mm}/${yyyy}`;
        
        // Set placeholder untuk tanggal input
        document.getElementById('tanggalInput').placeholder = `dd/mm/yyyy (contoh: ${todayFormatted})`;
        
        // Set selected time option jika ada value
        const jamValue = document.getElementById('jamInput').value;
        if (jamValue) {
            selectTime(jamValue);
        }
    });
</script>

</body>
</html>