<?php 
include 'koneksi.php'; 

// Fungsi untuk format skor SAW
function formatScoreSAW($value) {
    if ($value > 1) {
        $value = $value / 100;
    }
    return max(0, min(1, round($value, 2)));
}

// Ambil bobot kriteria dari database
$kriteria_query = mysqli_query($conn, "SELECT * FROM kriteria ORDER BY id_kriteria");
$bobot_data = [];

while ($row = mysqli_fetch_assoc($kriteria_query)) {
    $bobot = $row['bobot'] / 100; // Konversi persen ke desimal (0-1)
    $bobot_data[$row['nama_kriteria']] = $bobot;
}

// Ambil semua treatment
$treatment_query = mysqli_query($conn, "SELECT * FROM treatment");
$treatments = [];

// Data untuk normalisasi SAW
$min_values = [];
$max_values = [];

// Kriteria yang digunakan
$kriteria_list = ['harga', 'durasi', 'hasil', 'kepuasan', 'aman'];

// Inisialisasi min dan max
foreach ($kriteria_list as $kriteria) {
    $min_values[$kriteria] = PHP_FLOAT_MAX;
    $max_values[$kriteria] = PHP_FLOAT_MIN;
}

// Langkah 1: Kumpulkan data dan cari min/max
while ($row = mysqli_fetch_assoc($treatment_query)) {
    $treatment = [
        'id' => $row['id'],
        'nama' => $row['nama'],
        'scores' => []
    ];
    
    // Format skor ke 0-1 untuk SAW
    $treatment['scores']['harga'] = formatScoreSAW($row['harga_score']);
    $treatment['scores']['durasi'] = formatScoreSAW($row['durasi_score']);
    $treatment['scores']['hasil'] = formatScoreSAW($row['hasil_score']);
    $treatment['scores']['kepuasan'] = formatScoreSAW($row['kepuasan_score']);
    $treatment['scores']['aman'] = formatScoreSAW($row['aman_score']);
    
    // Update min dan max untuk normalisasi
    foreach ($kriteria_list as $kriteria) {
        $score = $treatment['scores'][$kriteria];
        if ($score < $min_values[$kriteria]) {
            $min_values[$kriteria] = $score;
        }
        if ($score > $max_values[$kriteria]) {
            $max_values[$kriteria] = $score;
        }
    }
    
    $treatments[] = $treatment;
}

// Langkah 2: Hitung skor SAW untuk setiap treatment
$best = []; // Array untuk menyimpan hasil skor akhir

foreach ($treatments as $treatment) {
    $total_score = 0;
    
    foreach ($kriteria_list as $kriteria) {
        $score = $treatment['scores'][$kriteria];
        $bobot = isset($bobot_data[$kriteria]) ? $bobot_data[$kriteria] : 0.2;
        
        // Normalisasi (Semakin tinggi semakin baik)
        if ($max_values[$kriteria] != $min_values[$kriteria]) {
            $normalized = ($score - $min_values[$kriteria]) / ($max_values[$kriteria] - $min_values[$kriteria]);
        } else {
            $normalized = 1;
        }
        
        // Skor terhitung = bobot × normalized
        $weighted_score = $bobot * $normalized;
        $total_score += $weighted_score;
    }
    
    // Simpan skor akhir (0-100%)
    $final_score = round($total_score * 100, 2);
    $best[$treatment['nama']] = $final_score;
}

// Urutkan berdasarkan skor tertinggi
arsort($best);
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Rekomendasi Treatment - Mahera Beauty</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
      background: #f9f7f5;
      color: #5d4037;
      line-height: 1.6;
      min-height: 100vh;
      padding: 20px;
    }

    .container {
      max-width: 1200px;
      margin: 0 auto;
    }

    /* Header */
    .header {
      text-align: center;
      margin-bottom: 40px;
      padding: 35px 0;
      background: #fffbf8;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(93, 64, 55, 0.08);
      border: 1px solid #e8d7c9;
      position: relative;
    }

    .header h1 {
      font-size: 28px;
      font-weight: 600;
      color: #5d4037;
      margin-bottom: 10px;
      padding-right: 60px;
    }

    .header p {
      color: #8d6e63;
      font-size: 16px;
    }

    /* Navigation Desktop */
    .nav-desktop {
      display: flex;
      justify-content: center;
      gap: 12px;
      margin-bottom: 40px;
      flex-wrap: wrap;
    }

    .nav-desktop a {
      padding: 12px 24px;
      text-decoration: none;
      border-radius: 8px;
      font-weight: 500;
      font-size: 14px;
      transition: all 0.3s ease;
      background: #fffbf8;
      color: #795548;
      border: 1px solid #d7ccc8;
    }

    .nav-desktop a:hover {
      background: #8d6e63;
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(141, 110, 99, 0.2);
    }

    .nav-desktop a.active {
      background: #8d6e63;
      color: white;
      border-color: #8d6e63;
    }

    /* ================= HAMBURGER MENU ================= */
    .hamburger-btn {
        display: none;
        position: absolute;
        top: 10px;
        right: 5px;
        background: #8d6e63;
        border: none;
        width: 30px;
        height: 20px;
        border-radius: 15px;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        cursor: pointer;
        z-index: 1001;
        box-shadow: 0 4px 10px rgba(141, 110, 99, 0.3);
        transition: all 0.3s ease;
    }

    .hamburger-btn:hover {
        transform: scale(1.05);
        box-shadow: 0 6px 15px rgba(141, 110, 99, 0.4);
    }

    .hamburger-btn span {
        display: block;
        width: 25px;
        height: 3px;
        background: white;
        margin: 3px 0;
        border-radius: 2px;
        transition: all 0.3s ease;
    }

    /* Mobile Menu Overlay */
    .mobile-nav-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 999;
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .mobile-nav-overlay.active {
        display: block;
        opacity: 1;
    }

    /* Mobile Menu Sidebar */
    .mobile-nav {
        position: fixed;
        top: 0;
        right: -300px;
        width: 280px;
        height: 100%;
        background: #fffbf8;
        z-index: 1000;
        padding: 80px 20px 20px;
        box-shadow: -5px 0 20px rgba(0, 0, 0, 0.2);
        transition: right 0.3s ease;
        overflow-y: auto;
    }

    .mobile-nav.active {
        right: 0;
    }

    .mobile-nav a {
        display: block;
        text-decoration: none;
        background: #8d6e63;
        color: #fff;
        padding: 15px 20px;
        border-radius: 10px;
        margin: 10px 0;
        font-weight: 500;
        text-align: center;
        transition: all 0.3s ease;
        box-shadow: 0 4px 10px rgba(141, 110, 99, 0.3);
    }

    .mobile-nav a:hover {
        transform: translateX(-5px);
        background: #a1887f;
        box-shadow: 0 6px 15px rgba(141, 110, 99, 0.4);
    }

    .mobile-nav a.active {
      background: #5d4037;
    }

    /* Close button inside mobile menu */
    .close-menu {
        position: absolute;
        top: 20px;
        right: 20px;
        background: #5d4037;
        color: white;
        border: none;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        font-size: 20px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* Info Box */
    .info-box {
      background: #f5efeb;
      border: 1px solid #e0d5cc;
      border-radius: 10px;
      padding: 20px;
      margin-bottom: 30px;
      font-size: 14px;
      color: #795548;
      text-align: center;
      border-left: 4px solid #a1887f;
    }

    /* Table Container */
    .table-container {
      background: white;
      border-radius: 10px;
      box-shadow: 0 4px 20px rgba(93, 64, 55, 0.08);
      overflow: hidden;
      margin-bottom: 40px;
      border: 1px solid #e8d7c9;
    }

    /* Table */
    .table {
      width: 100%;
      border-collapse: collapse;
    }

    .table th {
      background: #f5efeb;
      padding: 18px 20px;
      text-align: left;
      font-weight: 600;
      color: #5d4037;
      border-bottom: 2px solid #d7ccc8;
      font-size: 14px;
      letter-spacing: 0.5px;
    }

    .table th:first-child {
      width: 80px;
      text-align: center;
      border-top-left-radius: 12px;
    }

    .table th:last-child {
      width: 150px;
      text-align: right;
      border-top-right-radius: 12px;
    }

    .table td {
      padding: 16px 20px;
      border-bottom: 1px solid #f0e6e0;
      font-size: 14px;
      color: #5d4037;
    }

    .table tr:last-child td {
      border-bottom: none;
    }

    .table tr:hover {
      background-color: #faf6f3;
    }

    .table td:first-child {
      text-align: center;
      font-weight: 500;
      color: #795548;
      font-size: 15px;
    }

    .table td:nth-child(2) {
      font-weight: 500;
      color: #5d4037;
    }

    .table td:last-child {
      text-align: right;
      font-weight: 500;
    }

    /* Highlight untuk peringkat 1 */
    .table tr:first-child {
      background: #f5efeb;
      border-left: 3px solid #8d6e63;
    }

    .table tr:first-child td {
      font-weight: 500;
    }

    .table tr:first-child td:first-child {
      font-weight: 600;
      color: #5d4037;
    }

    /* Skor */
    .score {
      font-size: 13px;
      color: #5d4037;
      background: #f5efeb;
      padding: 6px 14px;
      border-radius: 20px;
      border: 1px solid #d7ccc8;
      display: inline-block;
      font-weight: 500;
      min-width: 80px;
      text-align: center;
    }

    /* Footer */
    .footer {
      text-align: center;
      padding: 30px 0;
      color: #8d6e63;
      font-size: 13px;
      border-top: 1px solid #e8d7c9;
      margin-top: 40px;
      background: #fffbf8;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(93, 64, 55, 0.08);
      border: 1px solid #e8d7c9;
    }

    .footer p {
      margin-bottom: 8px;
    }

    .footer strong {
      color: #5d4037;
    }

    /* ================= WHATSAPP FLOAT ================= */
    .whatsapp-float {
        position: fixed;
        width: 60px;
        height: 60px;
        bottom: 40px;
        right: 40px;
        background-color: #25d366;
        color: #FFF;
        border-radius: 50px;
        text-align: center;
        font-size: 30px;
        box-shadow: 2px 2px 3px #999;
        z-index: 100;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
    }

    .whatsapp-float:hover {
        background-color: #128C7E;
        color: white;
        transform: scale(1.1);
    }

    /* ================= RESPONSIVE ================= */

    /* Tablet (768px - 1024px) */
    @media (max-width: 1024px) {
      .table-container {
        overflow-x: auto;
      }
      
      .table {
        min-width: 600px;
      }
    }

    /* Tablet Kecil (768px dan di bawah) */
    @media (max-width: 768px) {
      .container {
        padding: 10px;
      }

      /* Sembunyikan navbar desktop, tampilkan hamburger */
      .nav-desktop {
        display: none;
      }
      
      .hamburger-btn {
        display: flex;
      }
      
      .header h1 {
        font-size: 22px;
        padding-right: 60px;
      }
      
      .header p {
        font-size: 14px;
      }

      .info-box {
        font-size: 13px;
        padding: 15px;
      }

      .table th,
      .table td {
        padding: 12px 15px;
        font-size: 13px;
      }

      .header {
        padding: 20px 0;
      }

      .table-container {
        overflow-x: auto;
      }

      .table {
        min-width: 500px;
      }

      .score {
        font-size: 12px;
        padding: 4px 12px;
        min-width: 70px;
      }
      
      .whatsapp-float {
        width: 55px;
        height: 55px;
        bottom: 30px;
        right: 30px;
        font-size: 26px;
      }
    }

    /* HP (480px - 600px) */
    @media (max-width: 600px) {
      body {
        padding: 10px;
      }
      
      .header h1 {
        font-size: 1.6em;
        padding-right: 55px;
      }
      
      .hamburger-btn {
        top: 25px;
        right: 15px;
        width: 45px;
        height: 45px;
      }
      
      .mobile-nav {
        width: 250px;
      }
      
      .info-box {
        padding: 12px;
        font-size: 12px;
      }
      
      .table th,
      .table td {
        padding: 10px 12px;
        font-size: 12px;
      }
      
      .score {
        font-size: 11px;
        padding: 3px 10px;
        min-width: 60px;
      }
      
      .whatsapp-float {
        width: 50px;
        height: 50px;
        bottom: 25px;
        right: 25px;
        font-size: 24px;
      }
    }

    /* HP Kecil (di bawah 480px) */
    @media (max-width: 480px) {
      body {
        font-size: 14px;
      }
      
      .header h1 {
        font-size: 1.4em;
        padding-right: 50px;
      }
      
      .hamburger-btn {
        top: 20px;
        right: 10px;
        width: 40px;
        height: 40px;
      }
      
      .hamburger-btn span {
        width: 22px;
        height: 2.5px;
        margin: 2.5px 0;
      }
      
      .mobile-nav {
        width: 220px;
        padding: 70px 15px 15px;
      }
      
      .mobile-nav a {
        padding: 12px 15px;
        font-size: 0.9em;
      }
      
      .info-box {
        padding: 10px;
        font-size: 11px;
      }
      
      .table th,
      .table td {
        padding: 8px 10px;
        font-size: 11px;
      }
      
      .score {
        font-size: 10px;
        padding: 2px 8px;
        min-width: 50px;
      }
      
      .whatsapp-float {
        width: 45px;
        height: 45px;
        bottom: 20px;
        right: 20px;
        font-size: 22px;
      }
    }

    /* Animasi */
    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .table-container {
      animation: fadeIn 0.5s ease-out;
    }

    .table tr {
      animation: fadeIn 0.3s ease-out;
      animation-fill-mode: both;
    }

    .table tr:nth-child(1) { animation-delay: 0.1s; }
    .table tr:nth-child(2) { animation-delay: 0.2s; }
    .table tr:nth-child(3) { animation-delay: 0.3s; }
    .table tr:nth-child(4) { animation-delay: 0.4s; }
    .table tr:nth-child(5) { animation-delay: 0.5s; }
    .table tr:nth-child(6) { animation-delay: 0.6s; }
    .table tr:nth-child(7) { animation-delay: 0.7s; }
    .table tr:nth-child(8) { animation-delay: 0.8s; }
    .table tr:nth-child(9) { animation-delay: 0.9s; }
    .table tr:nth-child(10) { animation-delay: 1.0s; }
  </style>
</head>
<body>
  <div class="container">
    <!-- Header -->
    <div class="header">
      <h1>Hasil Rekomendasi Treatment</h1>
      <p>Perhitungan menggunakan metode SAW (Simple Additive Weighting)</p>
      
      <!-- Hamburger Button untuk Mobile -->
      <button class="hamburger-btn" id="hamburgerBtn">
        <span></span>
        <span></span>
        <span></span>
      </button>
    </div>

    <!-- Desktop Navigation -->
    <div class="nav-desktop">
      <a href="home.php">Home</a>
      <a href="treatment.php">Treatment</a>
      <a href="rekomendasi.php" class="active">Rekomendasi</a>
      <a href="testimoni.php">Testimoni</a>
      <a href="konsultasi.php">Konsultasi</a>
    </div>

    <!-- Mobile Navigation Overlay & Menu -->
    <div class="mobile-nav-container">
        <div class="mobile-nav-overlay" id="mobileOverlay"></div>
        <nav class="mobile-nav" id="mobileNav">
            <button class="close-menu" id="closeMenu">×</button>
            <a href="home.php">Home</a>
            <a href="treatment.php">Treatment</a>
            <a href="rekomendasi.php" class="active">Rekomendasi</a>
            <a href="testimoni.php">Testimoni</a>
            <a href="konsultasi.php">Konsultasi</a>
        </nav>
    </div>

    <!-- Info Box -->
    <div class="info-box">
      Skor dihitung menggunakan metode SAW dengan normalisasi data. Skor tertinggi menandakan rekomendasi terbaik.
    </div>

    <!-- Table -->
    <div class="table-container">
      <table class="table">
        <thead>
          <tr>
            <th>No</th>
            <th>Nama Treatment</th>
            <th>Skor Akhir</th>
          </tr>
        </thead>
        <tbody>
          <?php 
          $i = 1; 
          foreach ($best as $name => $score): 
          ?>
          <tr>
            <td><?php echo $i++; ?></td>
            <td><?php echo htmlspecialchars($name); ?></td>
            <td>
              <span class="score"><?php echo number_format($score, 2); ?>%</span>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <!-- Footer -->
    <div class="footer">
      <p><strong>© <?php echo date('Y'); ?> Mahera Beauty - Skincare Center</strong></p>
      <p>Sistem Rekomendasi Treatment menggunakan Metode SAW</p>
    </div>
  </div>

  <script>
    // JavaScript untuk hamburger menu
    const hamburgerBtn = document.getElementById('hamburgerBtn');
    const closeMenu = document.getElementById('closeMenu');
    const mobileNav = document.getElementById('mobileNav');
    const mobileOverlay = document.getElementById('mobileOverlay');
    
    hamburgerBtn.addEventListener('click', () => {
        mobileNav.classList.add('active');
        mobileOverlay.classList.add('active');
        document.body.style.overflow = 'hidden';
    });
    
    closeMenu.addEventListener('click', () => {
        mobileNav.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.style.overflow = 'auto';
    });
    
    mobileOverlay.addEventListener('click', () => {
        mobileNav.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.style.overflow = 'auto';
    });
    
    const mobileLinks = document.querySelectorAll('.mobile-nav a');
    mobileLinks.forEach(link => {
        link.addEventListener('click', () => {
            mobileNav.classList.remove('active');
            mobileOverlay.classList.remove('active');
            document.body.style.overflow = 'auto';
        });
    });
    
    // Close menu dengan ESC key
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            mobileNav.classList.remove('active');
            mobileOverlay.classList.remove('active');
            document.body.style.overflow = 'auto';
        }
    });

    // Animasi tambahan untuk tabel
    document.addEventListener('DOMContentLoaded', function() {
      const rows = document.querySelectorAll('.table tr');
      rows.forEach((row, index) => {
        row.style.opacity = '0';
        row.style.transform = 'translateY(10px)';
        
        setTimeout(() => {
          row.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
          row.style.opacity = '1';
          row.style.transform = 'translateY(0)';
        }, index * 50);
      });
    });
  </script>
</body>
</html>