<?php
include 'koneksi.php';

$testimoni_query = mysqli_query($conn, "SELECT * FROM testimoni ORDER BY id DESC LIMIT 4");
$testimonials = [];
while ($row = mysqli_fetch_assoc($testimoni_query)) {
    $testimonials[] = $row;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Treatment Mahera - Home</title>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
*{
  margin:0;
  padding:0;
  box-sizing:border-box;
}
body{
  font-family:'Segoe UI', Tahoma, sans-serif;
  background:#fff;
  color:#5b4033;
  overflow-x: hidden;
}
.container{
  max-width:1200px;
  margin:auto;
  padding:0 15px;
}

/* ================= HEADER ================= */
header{
  display:flex;
  align-items:center;
  justify-content:center;
  gap:15px;
  padding:25px 0;
  position: relative;
}
.logo{
  font-size:2.5em;
  color:#8b5e3c;
}
header h1{
  font-size:2.2em;
  color:#8b5e3c;
  text-align: center;
}

/* ================= NAVBAR DESKTOP (TETAP) ================= */


    /* Navigation Desktop */
    .nav-desktop {
      display: flex;
      justify-content: center;
      gap: 12px;
      margin-bottom: 40px;
      flex-wrap: wrap;
    }

    .nav-desktop a {
      padding: 12px 24px;
      text-decoration: none;
      border-radius: 8px;
      font-weight: 500;
      font-size: 14px;
      transition: all 0.3s ease;
      background: #fffbf8;
      color: #795548;
      border: 1px solid #d7ccc8;
    }

    .nav-desktop a:hover {
      background: #8d6e63;
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(141, 110, 99, 0.2);
    }

    .nav-desktop a.active {
      background: #8d6e63;
      color: white;
      border-color: #8d6e63;
    }
/* ================= HAMBURGER MENU ================= */
.hamburger-btn {
    display: none;
    position: absolute;
    top: 30px;
    right: 20px;
    background: #8b5e3c;
    border: none;
    width: 50px;
    height: 50px;
    border-radius: 10px;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    cursor: pointer;
    z-index: 1001;
    box-shadow: 0 4px 10px rgba(139, 94, 60, 0.3);
    transition: all 0.3s ease;
}

.hamburger-btn:hover {
    transform: scale(1.05);
    box-shadow: 0 6px 15px rgba(139, 94, 60, 0.4);
}

.hamburger-btn span {
    display: block;
    width: 25px;
    height: 3px;
    background: white;
    margin: 3px 0;
    border-radius: 2px;
    transition: all 0.3s ease;
}

/* Mobile Menu Overlay */
.mobile-nav-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    z-index: 999;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.mobile-nav-overlay.active {
    display: block;
    opacity: 1;
}

/* Mobile Menu Sidebar */
.mobile-nav {
    position: fixed;
    top: 0;
    right: -300px;
    width: 280px;
    height: 100%;
    background: #fff5f6;
    z-index: 1000;
    padding: 80px 20px 20px;
    box-shadow: -5px 0 20px rgba(0, 0, 0, 0.2);
    transition: right 0.3s ease;
    overflow-y: auto;
}

.mobile-nav.active {
    right: 0;
}

.mobile-nav a {
    display: block;
    text-decoration: none;
    background: #8b5e3c;
    color: #fff;
    padding: 15px 20px;
    border-radius: 10px;
    margin: 10px 0;
    font-weight: 500;
    text-align: center;
    transition: all 0.3s ease;
    box-shadow: 0 4px 10px rgba(139, 94, 60, 0.3);
}

.mobile-nav a:hover {
    transform: translateX(-5px);
    background: #a9744b;
    box-shadow: 0 6px 15px rgba(139, 94, 60, 0.4);
}

.mobile-nav .btn-nav {
    background: #5b4033;
}

/* Close button inside mobile menu */
.close-menu {
    position: absolute;
    top: 20px;
    right: 20px;
    background: #5b4033;
    color: white;
    border: none;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    font-size: 20px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* ================= HERO ================= */
.hero-home{
  display:flex;
  align-items:center;
  justify-content:space-between;
  gap:40px;
  background:#fff5f6;
  padding:60px;
  border-radius:30px;
  margin-bottom:70px;
}
.hero-text{
  flex:1;
}
.hero-text h2{
  font-size:3em;
  color:#e53950;
  line-height:1.25;
  font-weight:700;
}
.hero-text p{
  margin-top:25px;
  font-size:1.1em;
  color:#555;
  max-width:500px;
}
.hero-image{
  flex:1;
  text-align:right;
}
.hero-image img{
  max-width:480px;
  width:100%;
  border-radius:20px;
}

/* ================= SECTION TITLE ================= */
.section-title{
  text-align:center;
  font-size:2em;
  margin-bottom:40px;
  color:#5b4033;
}

/* REKOMENDASI */
.rekomendasi-grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
  gap:30px;
  margin-bottom:80px;
}
.rekomendasi-card{
  background:#fff;
  padding:35px;
  border-radius:22px;
  text-align:center;
  box-shadow:0 10px 25px rgba(0,0,0,.08);
  text-decoration:none;
  color:#5b4033;
  transition:.3s;
}
.rekomendasi-card:hover{
  transform:translateY(-6px);
  background:#8b5e3c;
  color:#fff;
}
.rekomendasi-card i{
  font-size:3em;
  margin-bottom:15px;
}

/* ================= KEUNGGULAN ================= */
.features-grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(250px,1fr));
  gap:30px;
  margin-bottom:70px;
}
.feature-card{
  background:#fff;
  padding:35px 25px;
  border-radius:20px;
  text-align:center;
  box-shadow:0 10px 25px rgba(0,0,0,.08);
}
.feature-icon{
  font-size:2.8em;
  color:#8b5e3c;
  margin-bottom:15px;
}
.feature-card h3{
  margin-bottom:12px;
  font-size:1.3em;
}
.feature-card p{
  font-size:0.95em;
  line-height:1.6;
  color:#7a5a45;
}

/* ================= TESTIMONI ================= */
.testimoni-grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(250px,1fr));
  gap:25px;
  margin-bottom:80px;
}
.testimoni-card{
  background:#fff;
  padding:25px;
  border-radius:20px;
  box-shadow:0 10px 25px rgba(0,0,0,.08);
}
.testimoni-text{
  font-style:italic;
  margin-bottom:15px;
}
.testimoni-author{
  display:flex;
  gap:10px;
  align-items:center;
}
.author-avatar{
  width:42px;
  height:42px;
  border-radius:50%;
  background:#8b5e3c;
  color:#fff;
  display:flex;
  align-items:center;
  justify-content:center;
  font-weight:bold;
}

/* ================= FOOTER ================= */
.footer{
  background:#f8f9fa;
  padding:30px 0;
  text-align:center;
  border-top:1px solid #ddd;
}
.social-media{
  display:flex;
  justify-content:center;
  gap:15px;
  margin-bottom:15px;
}
.social-media a{
  width:40px;
  height:40px;
  background:#8b5e3c;
  color:#fff;
  border-radius:50%;
  display:flex;
  align-items:center;
  justify-content:center;
  transition:.3s;
}
.social-media a:hover{
  transform:translateY(-3px);
  background:#5b4033;
}
.contact-info p{
  font-size:14px;
  color:#666;
  margin:5px 0;
}

/* ================= WHATSAPP FLOAT ================= */
.whatsapp-float {
    position: fixed;
    width: 60px;
    height: 60px;
    bottom: 40px;
    right: 40px;
    background-color: #25d366;
    color: #FFF;
    border-radius: 50px;
    text-align: center;
    font-size: 30px;
    box-shadow: 2px 2px 3px #999;
    z-index: 100;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
}

.whatsapp-float:hover {
    background-color: #128C7E;
    color: white;
    transform: scale(1.1);
}

/* ================= RESPONSIVE ================= */

/* Tablet (768px - 1024px) */
@media (max-width: 1024px) {
  .hero-home {
    padding: 40px;
  }
  
  .hero-text h2 {
    font-size: 2.5em;
  }
  
  .rekomendasi-grid,
  .features-grid,
  .testimoni-grid {
    gap: 20px;
  }
}

/* Tablet Kecil (768px dan di bawah) */
@media (max-width: 768px){
  .hero-home{
    flex-direction:column;
    text-align:center;
    padding:40px 25px;
    margin-bottom: 50px;
  }
  
  .hero-image{
    text-align:center;
  }
  
  .hero-text h2{
    font-size:2.3em;
  }
  
  .hero-text p {
    max-width: 100%;
  }
  
  /* Sembunyikan navbar desktop, tampilkan hamburger */
  .nav-desktop {
    display: none;
  }
  
  .hamburger-btn {
    display: flex;
  }
  
  header h1 {
    font-size: 1.8em;
    padding-right: 60px;
  }
  
  .section-title {
    font-size: 1.8em;
    margin-bottom: 30px;
  }
  
  .rekomendasi-grid,
  .features-grid,
  .testimoni-grid {
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 20px;
    margin-bottom: 50px;
  }
  
  .rekomendasi-card,
  .feature-card {
    padding: 25px 20px;
  }
  
  .whatsapp-float {
    width: 55px;
    height: 55px;
    bottom: 30px;
    right: 30px;
    font-size: 26px;
  }
}

/* HP (480px - 600px) */
@media (max-width: 600px) {
  .container {
    padding: 0 10px;
  }
  
  header {
    padding: 20px 0;
  }
  
  .logo {
    font-size: 2em;
  }
  
  header h1 {
    font-size: 1.6em;
    padding-right: 55px;
  }
  
  .hamburger-btn {
    top: 25px;
    right: 15px;
    width: 45px;
    height: 45px;
  }
  
  .mobile-nav {
    width: 250px;
  }
  
  .hero-home {
    padding: 30px 20px;
    border-radius: 20px;
  }
  
  .hero-text h2 {
    font-size: 1.8em;
    line-height: 1.3;
  }
  
  .hero-text p {
    font-size: 1em;
    margin-top: 15px;
  }
  
  .section-title {
    font-size: 1.6em;
    margin-bottom: 25px;
  }
  
  .rekomendasi-grid,
  .features-grid,
  .testimoni-grid {
    grid-template-columns: 1fr;
    gap: 15px;
  }
  
  .rekomendasi-card i,
  .feature-icon {
    font-size: 2.5em;
  }
  
  .whatsapp-float {
    width: 50px;
    height: 50px;
    bottom: 25px;
    right: 25px;
    font-size: 24px;
  }
}

/* HP Kecil (di bawah 480px) */
@media (max-width: 480px) {
  body {
    font-size: 14px;
  }
  
  header h1 {
    font-size: 1.4em;
    padding-right: 50px;
  }
  
  .hamburger-btn {
    top: 20px;
    right: 10px;
    width: 40px;
    height: 40px;
  }
  
  .hamburger-btn span {
    width: 22px;
    height: 2.5px;
    margin: 2.5px 0;
  }
  
  .mobile-nav {
    width: 220px;
    padding: 70px 15px 15px;
  }
  
  .mobile-nav a {
    padding: 12px 15px;
    font-size: 0.9em;
  }
  
  .hero-home {
    padding: 25px 15px;
    border-radius: 15px;
    margin-bottom: 40px;
  }
  
  .hero-text h2 {
    font-size: 1.6em;
  }
  
  .section-title {
    font-size: 1.4em;
    margin-bottom: 20px;
  }
  
  .rekomendasi-card,
  .feature-card,
  .testimoni-card {
    padding: 20px 15px;
    border-radius: 15px;
  }
  
  .social-media a {
    width: 35px;
    height: 35px;
    font-size: 0.9em;
  }
  
  .contact-info p {
    font-size: 12px;
  }
  
  .whatsapp-float {
    width: 45px;
    height: 45px;
    bottom: 20px;
    right: 20px;
    font-size: 22px;
  }
}

/* HP Sangat Kecil (di bawah 360px) */
@media (max-width: 360px) {
  .container {
    padding: 0 8px;
  }
  
  header h1 {
    font-size: 1.3em;
    padding-right: 45px;
  }
  
  .hamburger-btn {
    width: 35px;
    height: 35px;
    top: 18px;
    right: 8px;
  }
  
  .hamburger-btn span {
    width: 20px;
    height: 2px;
    margin: 2px 0;
  }
  
  .mobile-nav {
    width: 200px;
  }
  
  .hero-text h2 {
    font-size: 1.4em;
  }
  
  .hero-text p {
    font-size: 0.9em;
  }
}
</style>
</head>

<body>

<div class="container">

<header>
  <div class="logo"><i class="fas fa-spa"></i></div>
  <h1>Treatment Mahera</h1>
  
  <!-- Hamburger Button untuk Mobile -->
  <button class="hamburger-btn" id="hamburgerBtn">
    <span></span>
    <span></span>
    <span></span>
  </button>
</header>

<!-- Desktop Navigation -->
<nav class="nav-desktop">
  <a href="home.php">Home</a>
  <a href="treatment.php">Treatment</a>
  <a href="testimoni.php">Testimoni</a>
  <a href="konsultasi.php" class="btn-nav">Konsultasi</a>
</nav>

<!-- Mobile Navigation Overlay & Menu -->
<div class="mobile-nav-container">
    <div class="mobile-nav-overlay" id="mobileOverlay"></div>
    <nav class="mobile-nav" id="mobileNav">
        <button class="close-menu" id="closeMenu">×</button>
        <a href="home.php">Home</a>
        <a href="treatment.php">Treatment</a>
        <a href="testimoni.php">Testimoni</a>
        <a href="konsultasi.php" class="btn-nav">Konsultasi</a>
    </nav>
</div>

<!-- HERO -->
<section class="hero-home">
  <div class="hero-text">
    <h2>
      "Kulit sehat biki<br>
      kamu tampil lebih,<br>
     percaya diri <br>
      di setiap momen"
    </h2>
    <p>
      Treatment Mahera hadir sebagai solusi perawatan kulit
      yang aman, profesional, dan disesuaikan dengan kebutuhan
      setiap individu.
    </p>
  </div>
  <div class="hero-image">
    <img src="https://images.unsplash.com/photo-1616394584738-fc6e612e71b9?auto=format&fit=crop&w=800&q=80">
  </div>
</section>

<section>
<h2 class="section-title">Rekomendasi Treatment</h2>
<div class="rekomendasi-grid">
  <a href="konsultasi.php" class="rekomendasi-card">
    <i class="fas fa-comments"></i>
    <h3>Konsultasi Kulit</h3>
    <p>Input kondisi kulit Anda.</p>
  </a>

  <a href="rekomendasi.php" class="rekomendasi-card">
    <i class="fas fa-calculator"></i>
    <h3>Hasil Rekomendasi</h3>
    <p>Rekomendasi treatment terbaik.</p>
  </a>
</div>
</section>

<!-- KEUNGGULAN -->
<section>
  <h2 class="section-title">Keunggulan Kami</h2>
  <div class="features-grid">

    <div class="feature-card">
      <div class="feature-icon"><i class="fas fa-user-md"></i></div>
      <h3>Ahli Dermatologi</h3>
      <p>
        Ditangani oleh ahli kulit berpengalaman
        dengan sertifikasi resmi dan selalu mengikuti
        perkembangan teknologi terbaru.
      </p>
    </div>

    <div class="feature-card">
      <div class="feature-icon"><i class="fas fa-spa"></i></div>
      <h3>Treatment Personal</h3>
      <p>
        Setiap treatment disesuaikan dengan kondisi
        dan kebutuhan kulit masing-masing klien
        untuk hasil yang optimal.
      </p>
    </div>

    <div class="feature-card">
      <div class="feature-icon"><i class="fas fa-leaf"></i></div>
      <h3>Bahan Alami</h3>
      <p>
        Menggunakan bahan-bahan alami yang aman
        dan telah teruji klinis untuk perawatan
        kulit yang sehat.
      </p>
    </div>

    <div class="feature-card">
      <div class="feature-icon"><i class="fas fa-star"></i></div>
      <h3>Kepuasan Klien</h3>
      <p>
        Lebih dari 98% klien merasa puas
        dan merekomendasikan Treatment Mahera
        kepada keluarga dan teman.
      </p>
    </div>

  </div>
</section>

<!-- TESTIMONI -->
<section>
  <h2 class="section-title">Testimoni Klien Kami</h2>
  <div class="testimoni-grid">
    <?php foreach($testimonials as $t): ?>
    <div class="testimoni-card">
      <p class="testimoni-text">"<?= htmlspecialchars($t['pesan']) ?>"</p>
      <div class="testimoni-author">
        <div class="author-avatar"><?= strtoupper($t['nama'][0]) ?></div>
        <div>
          <strong><?= htmlspecialchars($t['nama']) ?></strong><br>
          <small><?= htmlspecialchars($t['treatment']) ?></small>
        </div>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
</section>

</div>

<div class="footer">
  <div class="social-media">
    <a href="#"><i class="fab fa-instagram"></i></a>
    <a href="#"><i class="fab fa-facebook-f"></i></a>
    <a href="#"><i class="fab fa-tiktok"></i></a>
  </div>
  <div class="contact-info">
    <p>Jl. Ahmad Dahlan, OKU Selatan</p>
    <p>Telp: (021) 1234-5678</p>
    <p>Email: info@treatmentmahera.com</p>
  </div>
</div>



<script>
    // JavaScript untuk hamburger menu
    const hamburgerBtn = document.getElementById('hamburgerBtn');
    const closeMenu = document.getElementById('closeMenu');
    const mobileNav = document.getElementById('mobileNav');
    const mobileOverlay = document.getElementById('mobileOverlay');
    
    hamburgerBtn.addEventListener('click', () => {
        mobileNav.classList.add('active');
        mobileOverlay.classList.add('active');
        document.body.style.overflow = 'hidden';
    });
    
    closeMenu.addEventListener('click', () => {
        mobileNav.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.style.overflow = 'auto';
    });
    
    mobileOverlay.addEventListener('click', () => {
        mobileNav.classList.remove('active');
        mobileOverlay.classList.remove('active');
        document.body.style.overflow = 'auto';
    });
    
    const mobileLinks = document.querySelectorAll('.mobile-nav a');
    mobileLinks.forEach(link => {
        link.addEventListener('click', () => {
            mobileNav.classList.remove('active');
            mobileOverlay.classList.remove('active');
            document.body.style.overflow = 'auto';
        });
    });
    
    // Close menu dengan ESC key
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            mobileNav.classList.remove('active');
            mobileOverlay.classList.remove('active');
            document.body.style.overflow = 'auto';
        }
    });
</script>

</body>
</html>