-- treatment_db for Treatment Mahera SPK
CREATE DATABASE IF NOT EXISTS treatment_db;
USE treatment_db;

CREATE TABLE admin (id INT AUTO_INCREMENT PRIMARY KEY, username VARCHAR(50), password VARCHAR(100));
CREATE TABLE kriteria (id_kriteria VARCHAR(20) PRIMARY KEY, nama_kriteria VARCHAR(100), bobot INT);
CREATE TABLE treatment (id INT AUTO_INCREMENT PRIMARY KEY, nama VARCHAR(200), keterangan TEXT, harga INT DEFAULT 0, harga_score INT DEFAULT 3, durasi_score INT DEFAULT 3, hasil_score INT DEFAULT 3, kepuasan_score INT DEFAULT 3, aman_score INT DEFAULT 3, image VARCHAR(200));
CREATE TABLE testimoni (id INT AUTO_INCREMENT PRIMARY KEY, nama VARCHAR(100), pesan TEXT, approved TINYINT DEFAULT 0);
CREATE TABLE booking (id INT AUTO_INCREMENT PRIMARY KEY, nama VARCHAR(100), hp VARCHAR(50), treatment_id INT, tanggal DATE, status VARCHAR(50) DEFAULT 'pending');

-- sample admin
INSERT INTO admin (username,password) VALUES ('admin','12345');

-- default kriteria and bobot (1-5)
INSERT INTO kriteria (id_kriteria,nama_kriteria,bobot) VALUES
('C1','harga',3),
('C2','durasi',2),
('C3','hasil',5),
('C4','kepuasan',4),
('C5','aman',4);

-- sample treatments (from price list)
INSERT INTO treatment (nama,keterangan,harga,harga_score,durasi_score,hasil_score,kepuasan_score,aman_score,image) VALUES
('Detox Whitening','Perawatan detoks dan pencerahan wajah',250000,3,3,4,4,4,'placeholder.png'),
('Detox Jerawat','Perawatan detoks khusus jerawat',200000,3,3,4,4,4,'placeholder.png'),
('Facial Whitening','Facial khusus mencerahkan kulit',180000,4,4,5,5,4,'placeholder.png'),
('Facial Hydrapeel','Facial hydrating + peel',220000,3,3,4,4,4,'placeholder.png');

-- sample testimoni
INSERT INTO testimoni (nama,pesan,approved) VALUES ('Sari','Pelayanannya memuaskan!',1),('Rina','Kulit saya makin cerah setelah treatment',1);

-- sample booking
INSERT INTO booking (nama,hp,treatment_id,tanggal,status) VALUES ('Ani','081234567890',1,'2025-11-10','pending');