<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['admin'])) {
    header('Location: login.php');
    exit;
}

function formatScore($value) {
    if ($value > 1) {
        $value = $value / 100;
    }
    return max(0, min(1, round($value, 2)));
}

// Tambah data
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['nama'])) {
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $harga = (int)$_POST['harga'];
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);
    
    $harga_score = formatScore($_POST['harga_score']);
    $durasi_score = formatScore($_POST['durasi_score']);
    $hasil_score = formatScore($_POST['hasil_score']);
    $kepuasan_score = formatScore($_POST['kepuasan_score']);
    $aman_score = formatScore($_POST['aman_score']);

    $image = 'placeholder.png';
    if (isset($_FILES['image']) && $_FILES['image']['tmp_name']) {
        $image = time() . '_' . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], '../images/' . $image);
    }

    $query = "INSERT INTO treatment (nama, keterangan, harga, harga_score, durasi_score, hasil_score, kepuasan_score, aman_score, image) 
              VALUES ('$nama', '$keterangan', $harga, $harga_score, $durasi_score, $hasil_score, $kepuasan_score, $aman_score, '$image')";
    mysqli_query($conn, $query);

    header('Location: treatment.php');
    exit;
}

// Hapus data
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $query = "DELETE FROM treatment WHERE id = $id";
    mysqli_query($conn, $query);
    header('Location: treatment.php');
    exit;
}

// Ambil data
$result = mysqli_query($conn, 'SELECT * FROM treatment ORDER BY id DESC');
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Treatment - Mahera Beauty</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #f9f3e9 0%, #f5ebe0 100%);
            color: #5d4037;
            padding: 20px;
            min-height: 100vh;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 12px;
            box-shadow: 0 8px 30px rgba(93, 64, 55, 0.1);
            padding: 30px;
            border: 1px solid #e0c9b8;
        }

        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #d7ccc8;
        }

        .title {
            font-size: 28px;
            font-weight: 700;
            color: #5d4037;
        }

        .nav {
            display: flex;
            gap: 15px;
        }

        .nav a {
            color: #8d6e63;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 6px;
            font-weight: 500;
            transition: all 0.3s ease;
            border: 2px solid #d7ccc8;
            background: #fffaf7;
        }

        .nav a:hover {
            background: #8d6e63;
            color: white;
            border-color: #8d6e63;
            transform: translateY(-2px);
        }

        /* Form */
        .form-container {
            background: linear-gradient(to bottom right, #fffaf7, #f8f0e8);
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 40px;
            border: 1px solid #e0c9b8;
            box-shadow: 0 4px 15px rgba(141, 110, 99, 0.08);
        }

        .form-title {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 25px;
            color: #5d4037;
            padding-bottom: 10px;
            border-bottom: 2px solid #d7ccc8;
        }

        .form-row {
            display: flex;
            flex-wrap: wrap;
            gap: 25px;
            margin-bottom: 20px;
        }

        .form-group {
            flex: 1;
            min-width: 250px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #795548;
            font-size: 14px;
        }

        .form-input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #d7ccc8;
            border-radius: 6px;
            font-size: 14px;
            background: white;
            transition: all 0.3s ease;
        }

        .form-input:focus {
            outline: none;
            border-color: #a1887f;
            box-shadow: 0 0 0 3px rgba(161, 136, 127, 0.1);
        }

        textarea.form-input {
            min-height: 80px;
            resize: vertical;
        }

        input[type="file"].form-input {
            padding: 10px;
            border-style: dashed;
        }

        .slider-container {
            margin-top: 5px;
        }

        input[type="range"].form-input {
            -webkit-appearance: none;
            height: 8px;
            background: #d7ccc8;
            border-radius: 4px;
            margin-top: 5px;
        }

        input[type="range"].form-input::-webkit-slider-thumb {
            -webkit-appearance: none;
            width: 20px;
            height: 20px;
            background: #8d6e63;
            border-radius: 50%;
            cursor: pointer;
            border: 2px solid white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }

        .slider-value {
            margin-top: 8px;
            font-size: 13px;
            color: #795548;
            font-weight: 500;
            padding: 4px 8px;
            background: #f5f0eb;
            border-radius: 4px;
            display: inline-block;
        }

        .submit-btn {
            background: linear-gradient(to right, #8d6e63, #a1887f);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 6px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 20px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(141, 110, 99, 0.2);
        }

        .submit-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(141, 110, 99, 0.3);
            background: linear-gradient(to right, #7b5b52, #8d6e63);
        }

        /* List Header */
        .list-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #d7ccc8;
        }

        .list-title {
            font-size: 22px;
            font-weight: 600;
            color: #5d4037;
        }

        .total-count {
            font-size: 14px;
            color: #8d6e63;
            background: #f5f0eb;
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 600;
        }

        /* Treatment List */
        .treatment-list {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .treatment-item {
            background: linear-gradient(to bottom right, #fffaf7, #f8f0e8);
            border-radius: 10px;
            padding: 25px;
            border: 1px solid #e0c9b8;
            transition: all 0.3s ease;
        }

        .treatment-item:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(141, 110, 99, 0.15);
            border-color: #a1887f;
        }

        .item-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
            gap: 20px;
        }

        .item-title {
            font-size: 20px;
            font-weight: 700;
            color: #5d4037;
            margin-bottom: 8px;
        }

        .item-price {
            font-size: 18px;
            color: #8d6e63;
            font-weight: 700;
            background: white;
            padding: 8px 15px;
            border-radius: 6px;
            border: 2px solid #d7ccc8;
            white-space: nowrap;
        }

        .item-desc {
            color: #795548;
            margin-bottom: 20px;
            line-height: 1.6;
            font-size: 14.5px;
            background: rgba(255, 255, 255, 0.7);
            padding: 12px;
            border-radius: 6px;
            border-left: 3px solid #d7ccc8;
        }

        .scores-container {
            margin-bottom: 20px;
            background: white;
            padding: 20px;
            border-radius: 8px;
            border: 1px solid #e0c9b8;
        }

        .scores-title {
            font-size: 14px;
            color: #795548;
            font-weight: 600;
            margin-bottom: 15px;
        }

        .scores-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            gap: 15px;
        }

        .score-item {
            text-align: center;
            padding: 10px;
            background: #f9f4ef;
            border-radius: 6px;
        }

        .score-label {
            font-size: 12px;
            color: #8d6e63;
            margin-bottom: 8px;
            font-weight: 600;
        }

        .score-bar {
            height: 10px;
            background: #e0d5cc;
            border-radius: 5px;
            margin-bottom: 8px;
            overflow: hidden;
        }

        .score-fill {
            height: 100%;
            background: linear-gradient(to right, #a1887f, #8d6e63);
        }

        .score-value {
            font-size: 14px;
            color: #5d4037;
            font-weight: 700;
        }

        .item-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-top: 20px;
            border-top: 1px solid #e0c9b8;
            margin-top: 20px;
        }

        .item-id {
            font-size: 13px;
            color: #a1887f;
            background: #f5f0eb;
            padding: 4px 10px;
            border-radius: 4px;
            font-weight: 500;
        }

        .item-actions {
            display: flex;
            gap: 10px;
        }

        .btn {
            padding: 8px 16px;
            border-radius: 6px;
            font-size: 13px;
            font-weight: 600;
            text-decoration: none;
            cursor: pointer;
            border: none;
            transition: all 0.3s ease;
        }

        .btn-edit {
            background: #fffaf7;
            color: #8d6e63;
            border: 2px solid #d7ccc8;
        }

        .btn-edit:hover {
            background: #8d6e63;
            color: white;
            border-color: #8d6e63;
            transform: translateY(-2px);
        }

        .btn-delete {
            background: #f8d7da;
            color: #721c24;
            border: 2px solid #f5c6cb;
        }

        .btn-delete:hover {
            background: #dc3545;
            color: white;
            border-color: #dc3545;
            transform: translateY(-2px);
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #a1887f;
            background: #f9f4ef;
            border-radius: 10px;
            border: 2px dashed #d7ccc8;
        }

        .empty-state p {
            font-size: 16px;
            font-weight: 500;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .scores-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }

            .nav {
                width: 100%;
                justify-content: flex-start;
                flex-wrap: wrap;
            }

            .item-header {
                flex-direction: column;
                align-items: flex-start;
            }

            .item-price {
                align-self: flex-start;
            }

            .scores-grid {
                grid-template-columns: repeat(2, 1fr);
            }

            .form-row {
                flex-direction: column;
                gap: 15px;
            }

            .form-group {
                min-width: 100%;
            }
        }

        @media (max-width: 480px) {
            .container {
                padding: 20px;
            }

            .scores-grid {
                grid-template-columns: 1fr;
            }

            .item-actions {
                flex-direction: column;
                width: 100%;
            }

            .btn {
                width: 100%;
                text-align: center;
            }

            .item-footer {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Header -->
    <div class="header">
        <h1 class="title">Treatment Management</h1>
        <div class="nav">
            <a href="dashboard.php">Dashboard</a>
        </div>
    </div>

    <!-- Form Tambah -->
    <div class="form-container">
        <h3 class="form-title">Tambah Treatment Baru</h3>
        <form method="post" enctype="multipart/form-data">
            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Nama Treatment</label>
                    <input type="text" name="nama" class="form-input" placeholder="Contoh: Facial Anti-Aging" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Harga (Rp)</label>
                    <input type="number" name="harga" class="form-input" placeholder="Contoh: 350000" min="0" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Keterangan</label>
                    <textarea name="keterangan" class="form-input" placeholder="Deskripsi lengkap treatment..." rows="3"></textarea>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Skor Harga (1 = Mahal, 0 = Murah)</label>
                    <div class="slider-container">
                        <input name="harga_score" type="range" class="form-input" min="0" max="1" value="0.5" step="0.01" required>
                        <div id="harga-display" class="slider-value">0.50 (50%)</div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Skor Durasi (1 = Lama, 0 = Cepat)</label>
                    <div class="slider-container">
                        <input name="durasi_score" type="range" class="form-input" min="0" max="1" value="0.5" step="0.01" required>
                        <div id="durasi-display" class="slider-value">0.50 (50%)</div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Skor Hasil (1 = Sangat Baik, 0 = Buruk)</label>
                    <div class="slider-container">
                        <input name="hasil_score" type="range" class="form-input" min="0" max="1" value="0.7" step="0.01" required>
                        <div id="hasil-display" class="slider-value">0.70 (70%)</div>
                    </div>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label class="form-label">Skor Kepuasan (1 = Sangat Puas, 0 = Tidak Puas)</label>
                    <div class="slider-container">
                        <input name="kepuasan_score" type="range" class="form-input" min="0" max="1" value="0.6" step="0.01" required>
                        <div id="kepuasan-display" class="slider-value">0.60 (60%)</div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Skor Keamanan (1 = Sangat Aman, 0 = Berisiko)</label>
                    <div class="slider-container">
                        <input name="aman_score" type="range" class="form-input" min="0" max="1" value="0.8" step="0.01" required>
                        <div id="aman-display" class="slider-value">0.80 (80%)</div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Gambar Treatment</label>
                    <input type="file" name="image" class="form-input" accept="image/*">
                    <small style="color: #a1887f; font-size: 12px; margin-top: 5px; display: block;">
                        Upload gambar treatment (JPG, PNG, GIF)
                    </small>
                </div>
            </div>

            <button class="submit-btn" type="submit">Simpan Treatment</button>
        </form>
    </div>

    <!-- Daftar Treatment -->
    <div class="list-header">
        <h2 class="list-title">Daftar Treatment</h2>
        <div class="total-count">Total: <?php echo mysqli_num_rows($result); ?> treatment</div>
    </div>

    <div class="treatment-list">
        <?php if (mysqli_num_rows($result) > 0): ?>
            <?php while ($row = mysqli_fetch_assoc($result)): 
                $harga = formatScore($row['harga_score']);
                $durasi = formatScore($row['durasi_score']);
                $hasil = formatScore($row['hasil_score']);
                $kepuasan = formatScore($row['kepuasan_score']);
                $aman = formatScore($row['aman_score']);
                
                $harga_pct = round($harga * 100);
                $durasi_pct = round($durasi * 100);
                $hasil_pct = round($hasil * 100);
                $kepuasan_pct = round($kepuasan * 100);
                $aman_pct = round($aman * 100);
            ?>
            <div class="treatment-item">
                <div class="item-header">
                    <div style="flex: 1;">
                        <h3 class="item-title"><?php echo htmlspecialchars($row['nama']); ?></h3>
                        <?php if ($row['keterangan']): ?>
                            <p class="item-desc"><?php echo htmlspecialchars($row['keterangan']); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="item-price">Rp <?php echo number_format($row['harga'], 0, ',', '.'); ?></div>
                </div>

                <div class="scores-container">
                    <div class="scores-title">Skor Evaluasi</div>
                    <div class="scores-grid">
                        <div class="score-item">
                            <div class="score-label">Harga</div>
                            <div class="score-bar">
                                <div class="score-fill" style="width: <?php echo $harga_pct; ?>%"></div>
                            </div>
                            <div class="score-value"><?php echo number_format($harga, 2); ?></div>
                        </div>
                        <div class="score-item">
                            <div class="score-label">Durasi</div>
                            <div class="score-bar">
                                <div class="score-fill" style="width: <?php echo $durasi_pct; ?>%"></div>
                            </div>
                            <div class="score-value"><?php echo number_format($durasi, 2); ?></div>
                        </div>
                        <div class="score-item">
                            <div class="score-label">Hasil</div>
                            <div class="score-bar">
                                <div class="score-fill" style="width: <?php echo $hasil_pct; ?>%"></div>
                            </div>
                            <div class="score-value"><?php echo number_format($hasil, 2); ?></div>
                        </div>
                        <div class="score-item">
                            <div class="score-label">Kepuasan</div>
                            <div class="score-bar">
                                <div class="score-fill" style="width: <?php echo $kepuasan_pct; ?>%"></div>
                            </div>
                            <div class="score-value"><?php echo number_format($kepuasan, 2); ?></div>
                        </div>
                        <div class="score-item">
                            <div class="score-label">Keamanan</div>
                            <div class="score-bar">
                                <div class="score-fill" style="width: <?php echo $aman_pct; ?>%"></div>
                            </div>
                            <div class="score-value"><?php echo number_format($aman, 2); ?></div>
                        </div>
                    </div>
                </div>

                <div class="item-footer">
                    <div class="item-id">ID: TR<?php echo str_pad($row['id'], 4, '0', STR_PAD_LEFT); ?></div>
                    <div class="item-actions">
                        <a class="btn btn-edit" href="edit.php?table=treatment&id=<?php echo $row['id']; ?>">Edit</a>
                        <a class="btn btn-delete" 
                           href="treatment.php?delete=<?php echo $row['id']; ?>"
                           onclick="return confirm('Yakin ingin menghapus treatment: <?php echo addslashes($row['nama']); ?>?')">Hapus</a>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="empty-state">
                <p>Belum ada data treatment. Silakan tambah treatment baru!</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    // Update slider display real-time
    const sliders = document.querySelectorAll('input[type="range"]');
    sliders.forEach(slider => {
        const displayId = slider.name.replace('_score', '-display');
        const display = document.getElementById(displayId);
        
        function updateDisplay() {
            const value = parseFloat(slider.value);
            const percent = Math.round(value * 100);
            display.textContent = value.toFixed(2) + ' (' + percent + '%)';
        }
        
        updateDisplay();
        slider.addEventListener('input', updateDisplay);
    });
    
    // Form validation
    document.querySelector('form').addEventListener('submit', function(e) {
        const nama = document.querySelector('input[name="nama"]').value.trim();
        const harga = document.querySelector('input[name="harga"]').value;
        
        if (!nama) {
            e.preventDefault();
            alert('Nama treatment harus diisi!');
            document.querySelector('input[name="nama"]').focus();
            return;
        }
        
        if (!harga || parseInt(harga) <= 0) {
            e.preventDefault();
            alert('Harga harus lebih dari 0!');
            document.querySelector('input[name="harga"]').focus();
            return;
        }
    });
</script>
</body>
</html>