<?php  
session_start();  
include '../koneksi.php';  

// Cek login admin  
if (!isset($_SESSION['admin'])) {  
    header('Location: login.php');  
    exit;  
}  

// Ambil data testimoni dengan urutan ID ascending (kecil ke besar)
$res = mysqli_query($conn, "SELECT * FROM testimoni ORDER BY id ASC");

// Approve testimoni  
if (isset($_GET['approve'])) {  
    $id = (int)$_GET['approve'];  
    mysqli_query($conn, "UPDATE testimoni SET approved = 1 WHERE id = {$id}");  
    header('Location: testimoni.php');  
    exit;  
}  

// Unapprove testimoni
if (isset($_GET['unapprove'])) {  
    $id = (int)$_GET['unapprove'];  
    mysqli_query($conn, "UPDATE testimoni SET approved = 0 WHERE id = {$id}");  
    header('Location: testimoni.php');  
    exit;  
}

// Hitung nomor urut
$counter = 1;
?>  

<!DOCTYPE html>  
<html lang="id">  
<head>  
    <meta charset="utf-8">  
    <title>Admin - Kelola Testimoni</title>  
    <style>
    /* =========================
       Reset & Variabel Warna
    ========================= */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    :root {
      --primary-brown: #5b4033;
      --secondary-brown: #8b5e3c;
      --light-brown: #a9744b;
      --accent-brown: #caa58a;
      --background: #fff8f5;
      --card-bg: #fff;
      --text-dark: #4b2e0f;
      --text-medium: #704531;
      --border-light: #efe9e4;
      --shadow: rgba(91, 64, 51, 0.08);
      --gradient-primary: linear-gradient(135deg, var(--secondary-brown), var(--light-brown));
    }

    body {
      font-family: 'Poppins', Arial, sans-serif;
      background: var(--background);
      color: var(--text-dark);
      line-height: 1.6;
      padding: 20px;
    }

    .container {
      max-width: 1200px;
      margin: 0 auto;
      background: var(--card-bg);
      padding: 30px;
      border-radius: 16px;
      box-shadow: 0 8px 25px var(--shadow);
      border: 1px solid var(--border-light);
    }

    h2 {
      text-align: center;
      color: var(--primary-brown);
      font-size: 2em;
      margin-bottom: 25px;
      font-weight: 700;
    }

    /* =========================
       Tombol
    ========================= */
    .btn {
      display: inline-block;
      background: var(--gradient-primary);
      color: #fff;
      padding: 10px 20px;
      border-radius: 10px;
      text-decoration: none;
      font-weight: 500;
      border: none;
      cursor: pointer;
      transition: all 0.3s ease;
      font-size: 14px;
      margin-right: 8px;
      box-shadow: 0 4px 10px rgba(139, 94, 60, 0.3);
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 15px rgba(139, 94, 60, 0.4);
    }

    .btn-kembali {
      background: var(--light-brown);
      margin-bottom: 20px;
    }

    .btn-approve {
      background: #28a745;
    }

    .btn-unapprove {
      background: #ffc107;
      color: #000;
    }

    .btn-delete {
      background: #dc3545;
    }

    /* =========================
       Tabel
    ========================= */
    .table-container {
      overflow-x: auto;
      margin-top: 20px;
      border-radius: 12px;
      border: 1px solid var(--border-light);
    }

    table {
      width: 100%;
      border-collapse: collapse;
      background: var(--card-bg);
    }

    th {
      background: var(--gradient-primary);
      color: white;
      padding: 15px 12px;
      text-align: left;
      font-weight: 600;
      font-size: 14px;
    }

    td {
      padding: 12px;
      border-bottom: 1px solid var(--border-light);
      background: #fffaf5;
    }

    tr:nth-child(even) td {
      background: #fdf3ed;
    }

    tr:hover td {
      background: #f9e9dd;
    }

    /* =========================
       Status Badge
    ========================= */
    .status-badge {
      padding: 6px 12px;
      border-radius: 20px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
    }

    .status-pending {
      background: #fff3cd;
      color: #856404;
      border: 1px solid #ffeaa7;
    }

    .status-approved {
      background: #d4edda;
      color: #155724;
      border: 1px solid #c3e6cb;
    }

    /* =========================
       Aksi Tabel
    ========================= */
    .aksi-group {
      display: flex;
      gap: 5px;
      flex-wrap: wrap;
    }

    .aksi-group .btn {
      padding: 6px 12px;
      font-size: 12px;
      margin: 2px;
    }

    /* =========================
       Nomor Urut
    ========================= */
    .nomor-urut {
      text-align: center;
      font-weight: bold;
      color: var(--primary-brown);
      background: #f8f0e8 !important;
      border-right: 2px solid var(--border-light);
      width: 60px;
    }

    /* =========================
       Kolom Pesan
    ========================= */
    .pesan-testimoni {
      max-width: 400px;
      word-wrap: break-word;
      line-height: 1.4;
    }

    /* =========================
       Empty State
    ========================= */
    .empty-state {
      text-align: center;
      padding: 40px;
      color: var(--text-medium);
    }

    .empty-state p {
      font-style: italic;
      margin-bottom: 15px;
    }

    /* =========================
       Header Tabel
    ========================= */
    .table-header {
      background: var(--gradient-primary);
      color: white;
    }

    .table-header th:first-child {
      border-radius: 10px 0 0 0;
    }

    .table-header th:last-child {
      border-radius: 0 10px 0 0;
    }

    /* =========================
       Responsive
    ========================= */
    @media (max-width: 768px) {
      .container {
        padding: 20px;
      }
      
      th, td {
        padding: 8px 6px;
        font-size: 13px;
      }
      
      .aksi-group {
        flex-direction: column;
      }
      
      .aksi-group .btn {
        margin: 2px 0;
        text-align: center;
      }
      
      .nomor-urut {
        font-size: 12px;
        padding: 8px 4px;
      }
      
      .pesan-testimoni {
        max-width: 200px;
      }
    }

    @media (max-width: 480px) {
      .container {
        padding: 15px;
      }
      
      h2 {
        font-size: 1.5em;
      }
      
      table {
        font-size: 12px;
      }
      
      .btn {
        padding: 8px 12px;
        font-size: 12px;
        margin-right: 5px;
      }
      
      .pesan-testimoni {
        max-width: 150px;
      }
    }
    </style>
</head>  
<body>  
    <div class="container">  
        <h2>📝 Kelola Testimoni</h2>  
        <a class="btn btn-kembali" href="dashboard.php">← Kembali ke Dashboard</a>  

        <div class="table-container">
            <table>  
                <thead>
                    <tr class="table-header">  
                        <th width="60">No</th>  
                        <th>Nama</th>  
                        <th>Pesan</th>  
                        <th width="100">Status</th>  
                        <th width="200">Aksi</th>  
                    </tr>  
                </thead>
                <tbody>
                    <?php 
                    if (mysqli_num_rows($res) > 0) {
                        while ($r = mysqli_fetch_assoc($res)) : ?>  
                            <tr>  
                                <td class="nomor-urut"><?= $counter++; ?></td>  
                                <td><strong><?= htmlspecialchars($r['nama']); ?></strong></td>  
                                <td class="pesan-testimoni"><?= htmlspecialchars($r['pesan']); ?></td>  
                                <td>
                                    <span class="status-badge <?= $r['approved'] ? 'status-approved' : 'status-pending'; ?>">
                                      <?= $r['approved'] ? ' Approved' : ' Pending'; ?>
                                    </span>
                                </td>  
                                <td>  
                                    <div class="aksi-group">
                                        <?php if (!$r['approved']) : ?>  
                                            <a class="btn btn-approve" href="testimoni.php?approve=<?= $r['id']; ?>" title="Setujui testimoni">
                                                 Approve
                                            </a>  
                                        <?php else : ?>
                                            <a class="btn btn-unapprove" href="testimoni.php?unapprove=<?= $r['id']; ?>" title="Batalkan persetujuan">
                                                 Unapprove
                                            </a>  
                                        <?php endif; ?>  
                                        <a class="btn btn-delete" href="delete.php?table=testimoni&id=<?= $r['id']; ?>" onclick="return confirm('Yakin hapus testimoni ini?')" title="Hapus testimoni">
                                             Hapus
                                        </a>  
                                    </div>
                                </td>  
                            </tr>  
                        <?php endwhile; 
                    } else {
                        echo '<tr><td colspan="5" class="empty-state"><p>📭 Belum ada testimoni</p></td></tr>';
                    }
                    ?>  
                </tbody>
            </table>  
        </div>

        <?php if (mysqli_num_rows($res) > 0): ?>
        <div style="margin-top: 20px; text-align: center; color: var(--text-medium); font-size: 14px;">
            <p>📊 Total: <strong><?= mysqli_num_rows($res); ?></strong> testimoni</p>
        </div>
        <?php endif; ?>
    </div>  

    <script>
    // Konfirmasi sebelum approve/unapprove
    document.addEventListener('DOMContentLoaded', function() {
        const approveLinks = document.querySelectorAll('.btn-approve, .btn-unapprove');
        
        approveLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                const action = this.classList.contains('btn-approve') ? 'menyetujui' : 'membatalkan persetujuan';
                const confirmMessage = `Yakin ${action} testimoni ini?`;
                
                if (!confirm(confirmMessage)) {
                    e.preventDefault();
                }
            });
        });
    });
    </script>
</body>  
</html>