<?php
include '../koneksi.php';
session_start();

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// --- DETAIL ---
$detail = null;
if (isset($_GET['detail'])) {
    $id = $_GET['detail'];
    $detail_query = mysqli_query($conn, "SELECT * FROM reservasi WHERE id_reservasi='$id'");
    if ($detail_query) {
        $detail = mysqli_fetch_assoc($detail_query);
    }
}

// --- UPDATE STATUS ---
if (isset($_POST['update_status'])) {
    $id = $_POST['id_reservasi'];
    $status = $_POST['status'];

    $update_query = mysqli_query($conn, "UPDATE reservasi SET status='$status' WHERE id_reservasi='$id'");

    if ($update_query) {
        echo "<script>alert('Status berhasil diperbarui!'); window.location='reservasi.php';</script>";
        exit;
    } else {
        echo "<script>alert('Gagal memperbarui status!');</script>";
    }
}

// --- DATA RESERVASI ---
$reservasi_query = mysqli_query($conn, "SELECT * FROM reservasi ORDER BY id_reservasi DESC");
if (!$reservasi_query) {
    die("Query Error: " . mysqli_error($conn));
}

// Hitung nomor urut
$counter = 1;
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Data Reservasi Admin</title>

<style>
body {
    background: #fff7f0;
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 20px;
    color: #4b2e05;
}

h2 {
    margin-bottom: 20px;
    font-size: 26px;
    color: #6e3b00;
    text-align: center;
}

.btn-kembali {
    display: inline-block;
    background: #8b5e34;
    color: white;
    padding: 10px 20px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: bold;
    margin-bottom: 20px;
    transition: background 0.3s;
    border: none;
    cursor: pointer;
}

.btn-kembali:hover {
    background: #6e3b00;
}

.table-container {
    background: white;
    padding: 20px;
    border-radius: 16px;
    box-shadow: 0 5px 16px rgba(0,0,0,0.1);
    margin-bottom: 30px;
}

table {
    width: 100%;
    border-collapse: collapse;
    font-size: 16px;
}

thead {
    background: #c49b63;
    color: white;
}

thead th {
    padding: 12px;
    text-align: center;
}

td {
    padding: 10px;
    border-bottom: 1px solid #eee4d8;
    text-align: center;
}

.nomor-urut {
    font-weight: bold;
    color: #6e3b00;
    background: #f8f0e8;
}

.btn-detail {
    background: #8b5e34;
    color: white;
    padding: 8px 14px;
    border-radius: 8px;
    text-decoration: none;
    font-weight: bold;
    transition: background 0.3s;
}

.btn-detail:hover {
    background: #6e3b00;
}

.detail-box {
    background: #fff;
    padding: 25px;
    box-shadow: 0 5px 16px rgba(0,0,0,0.15);
    border-radius: 16px;
    max-width: 450px;
    margin-top: 20px;
    margin-left: auto;
    margin-right: auto;
}

select, button {
    padding: 10px;
    width: 100%;
    border-radius: 10px;
    border: 1px solid #c49b63;
    margin-top: 10px;
}

button {
    background: #8b5e34;
    color: white;
    font-weight: bold;
    cursor: pointer;
    transition: background 0.3s;
}

button:hover {
    background: #6e3b00;
}

.error-message {
    background: #ffe6e6;
    color: #b30000;
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 20px;
    border-left: 4px solid #b30000;
    text-align: center;
}

.status-pending {
    color: #856404;
    background: #fff3cd;
    padding: 5px 10px;
    border-radius: 4px;
    font-weight: bold;
}

.status-disetujui {
    color: #155724;
    background: #d4edda;
    padding: 5px 10px;
    border-radius: 4px;
    font-weight: bold;
}

.status-ditolak {
    color: #721c24;
    background: #f8d7da;
    padding: 5px 10px;
    border-radius: 4px;
    font-weight: bold;
}

.total-info {
    text-align: center;
    margin-top: 15px;
    color: #6e3b00;
    font-weight: bold;
}
</style>
</head>
<body>

<a href="dashboard.php" class="btn-kembali">Kembali ke Dashboard</a>

<h2>Data Reservasi Pelanggan</h2>

<div class="table-container">
<?php
// Cek apakah query berhasil
if ($reservasi_query && mysqli_num_rows($reservasi_query) > 0) {
    $total_reservasi = mysqli_num_rows($reservasi_query);
?>
<table>
    <thead>
        <tr>
            <th width="60">No</th>
            <th>Nama</th>
            <th>Layanan</th>
            <th>Tanggal</th>
            <th>Jam</th>
            <th>Status</th>
            <th width="100">Aksi</th>
        </tr>
    </thead>

    <tbody>
    <?php while ($row = mysqli_fetch_assoc($reservasi_query)) { 
        $status_class = '';
        switch($row['status']) {
            case 'pending':
                $status_class = 'status-pending';
                break;
            case 'disetujui':
                $status_class = 'status-disetujui';
                break;
            case 'ditolak':
                $status_class = 'status-ditolak';
                break;
            default:
                $status_class = 'status-pending';
        }
    ?>
        <tr>
            <td class="nomor-urut"><?= $counter++; ?></td>
            <td><?= $row['nama_lengkap']; ?></td>
            <td><?= $row['layanan']; ?></td>
            <td><?= $row['tanggal']; ?></td>
            <td><?= $row['jam']; ?></td>

            <td>
                <span class="<?= $status_class; ?>">
                    <?= $row['status'] ? ucfirst($row['status']) : "Pending"; ?>
                </span>
            </td>

            <td>
                <a href="reservasi.php?detail=<?= $row['id_reservasi']; ?>" class="btn-detail">Detail</a>
            </td>
        </tr>
    <?php } ?>
    </tbody>
</table>

<div class="total-info">
    Total Reservasi: <?= $total_reservasi; ?>
</div>

<?php
} else {
    // Tampilkan pesan jika tidak ada data
    echo "<div class='error-message'>Tidak ada data reservasi atau terjadi kesalahan dalam mengambil data.</div>";
}
?>
</div>

<?php if ($detail) { ?>
<div class="detail-box">
    <h3>Detail Reservasi</h3>

    <p><strong>Nama:</strong> <?= $detail['nama_lengkap']; ?></p>
    <p><strong>No HP:</strong> <?= $detail['no_hp']; ?></p>
    <p><strong>Layanan:</strong> <?= $detail['layanan']; ?></p>
    <p><strong>Tanggal:</strong> <?= $detail['tanggal']; ?></p>
    <p><strong>Jam:</strong> <?= $detail['jam']; ?></p>
    <p><strong>Catatan:</strong> <?= $detail['catatan'] ? $detail['catatan'] : '-'; ?></p>
    <p><strong>Status Saat Ini:</strong> 
        <?php 
        $status_class = '';
        switch($detail['status']) {
            case 'pending': $status_class = 'status-pending'; break;
            case 'disetujui': $status_class = 'status-disetujui'; break;
            case 'ditolak': $status_class = 'status-ditolak'; break;
            default: $status_class = 'status-pending';
        }
        ?>
        <span class="<?= $status_class; ?>">
            <?= $detail['status'] ? ucfirst($detail['status']) : "Pending"; ?>
        </span>
    </p>

    <form method="POST">
        <input type="hidden" name="id_reservasi" value="<?= $detail['id_reservasi']; ?>">

        <label><strong>Update Status:</strong></label>
        <select name="status">
            <option value="pending" <?= $detail['status']=="pending"?"selected":""; ?>>Pending</option>
            <option value="disetujui" <?= $detail['status']=="disetujui"?"selected":""; ?>>Disetujui</option>
            <option value="ditolak" <?= $detail['status']=="ditolak"?"selected":""; ?>>Ditolak</option>
        </select>

        <button type="submit" name="update_status">Update Status</button>
    </form>
</div>
<?php } ?>

</body>
</html>