<?php
session_start();
include '../koneksi.php';

if (isset($_POST['register'])) {
  $username = mysqli_real_escape_string($conn, $_POST['username']);
  $password = mysqli_real_escape_string($conn, $_POST['password']);
  $confirm_password = mysqli_real_escape_string($conn, $_POST['confirm_password']);

  // Validasi input
  if (empty($username) || empty($password) || empty($confirm_password)) {
    $error = "Semua field harus diisi!";
  } elseif (strlen($username) < 3) {
    $error = "Username minimal 3 karakter!";
  } elseif (strlen($password) < 6) {
    $error = "Password minimal 6 karakter!";
  } elseif ($password !== $confirm_password) {
    $error = "Konfirmasi password tidak sesuai!";
  } else {
    // Cek apakah username sudah ada
    $check_query = mysqli_query($conn, "SELECT * FROM admin WHERE username='$username'");
    
    if (mysqli_num_rows($check_query) > 0) {
      $error = "Username sudah digunakan!";
    } else {
      // Hash password sebelum disimpan
      $hashed_password = password_hash($password, PASSWORD_DEFAULT);
      
      // Insert admin baru
      $insert_query = mysqli_query($conn, "INSERT INTO admin (username, password) VALUES ('$username', '$hashed_password')");
      
      if ($insert_query) {
        $_SESSION['admin'] = $username;
        header("Location: dashboard.php");
        exit;
      } else {
        $error = "Terjadi kesalahan saat mendaftar. Silakan coba lagi.";
      }
    }
  }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Register Admin - Treatment Mahera</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    :root {
      --primary-brown: #5b4033;
      --secondary-brown: #8b5e3c;
      --light-brown: #b67c47;
      --accent-brown: #d1a782;
      --background: #fff8f5;
      --card-bg: #ffffff;
      --text-dark: #4b2e0f;
      --text-medium: #704531;
      --shadow: rgba(0, 0, 0, 0.08);
    }

    body {
      font-family: 'Poppins', sans-serif;
      background-color: var(--background);
      color: var(--text-dark);
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      padding: 20px;
    }

    .register-container {
      background: var(--card-bg);
      padding: 40px 50px;
      border-radius: 16px;
      box-shadow: 0 8px 24px var(--shadow);
      border: 1px solid #efe9e4;
      width: 90%;
      max-width: 450px;
      text-align: center;
      animation: fadeIn 0.8s ease;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(-20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .register-container h2 {
      color: var(--primary-brown);
      font-size: 1.6em;
      margin-bottom: 25px;
    }

    .register-container form {
      text-align: left;
    }

    .register-container label {
      display: block;
      margin-bottom: 8px;
      color: var(--text-medium);
      font-weight: 600;
      font-size: 0.95em;
    }

    .register-container input[type="text"],
    .register-container input[type="password"] {
      width: 100%;
      padding: 12px;
      margin-bottom: 18px;
      border: 1px solid #ddd;
      border-radius: 10px;
      background: #fffaf6;
      transition: all 0.3s ease;
      font-size: 15px;
    }

    .register-container input:focus {
      border-color: var(--accent-brown);
      box-shadow: 0 0 6px rgba(202, 165, 138, 0.4);
      outline: none;
    }

    .register-container button {
      width: 100%;
      background-color: var(--light-brown);
      color: #fff;
      border: none;
      padding: 12px;
      font-size: 16px;
      border-radius: 10px;
      cursor: pointer;
      transition: background 0.3s ease, transform 0.2s ease;
      font-weight: 600;
      margin-top: 10px;
    }

    .register-container button:hover {
      background-color: var(--secondary-brown);
      transform: translateY(-2px);
    }

    .error-message {
      background-color: #ffe8e4;
      color: #a94442;
      padding: 10px;
      border-radius: 8px;
      margin-bottom: 15px;
      font-size: 0.9em;
      text-align: center;
    }

    .login-link {
      margin-top: 20px;
      text-align: center;
      font-size: 0.9em;
    }

    .login-link a {
      color: var(--light-brown);
      text-decoration: none;
      font-weight: 600;
    }

    .login-link a:hover {
      text-decoration: underline;
    }

    @media (max-width: 480px) {
      .register-container {
        padding: 30px 24px;
      }

      .register-container h2 {
        font-size: 1.3em;
      }
    }
  </style>
</head>
<body>
  <div class="register-container">
    <h2>Register Admin Baru</h2>

    <?php if (isset($error)) echo "<div class='error-message'>$error</div>"; ?>

    <form method="POST">
      <label>Username</label>
      <input type="text" name="username" placeholder="Masukkan username" required>

      <label>Password</label>
      <input type="password" name="password" placeholder="Masukkan password" required>

      <label>Konfirmasi Password</label>
      <input type="password" name="confirm_password" placeholder="Masukkan ulang password" required>

      <button type="submit" name="register">Daftar</button>
    </form>

    <div class="login-link">
      Sudah punya akun? <a href="login.php">Login di sini</a>
    </div>
  </div>
</body>
</html>