<?php
include '../koneksi.php';
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Konsultasi Kulit - Mahera Beauty</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
      background-color: #ffffff;
      color: #333333;
      line-height: 1.6;
    }
    
    .container {
      max-width: 600px;
      margin: 60px auto;
      background: #fff;
      padding: 40px;
      border-radius: 20px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
      border: 1px solid #f0f0f0;
    }
    
    .header {
      text-align: center;
      margin-bottom: 40px;
    }
    
    .header h1 {
      color: #2c3e50;
      font-size: 32px;
      font-weight: 700;
      margin-bottom: 10px;
      letter-spacing: -0.5px;
    }
    
    .header p {
      color: #7f8c8d;
      font-size: 16px;
      font-weight: 400;
    }
    
    .consultation-form {
      text-align: left;
    }
    
    .form-title {
      font-size: 18px;
      color: #2c3e50;
      margin-bottom: 25px;
      font-weight: 600;
      padding-bottom: 15px;
      border-bottom: 1px solid #f0f0f0;
    }
    
    .checkbox-group {
      display: flex;
      flex-direction: column;
      gap: 20px;
      margin-bottom: 40px;
    }
    
    .checkbox-item {
      display: flex;
      align-items: flex-start;
      padding: 18px 20px;
      background: #f8f9fa;
      border-radius: 12px;
      transition: all 0.3s ease;
      border: 2px solid transparent;
    }
    
    .checkbox-item:hover {
      background: #f0f7ff;
      border-color: #e3f2fd;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
    
    .checkbox-item input[type="checkbox"] {
      margin-top: 3px;
      margin-right: 15px;
      width: 20px;
      height: 20px;
      cursor: pointer;
      accent-color: #3498db;
    }
    
    .checkbox-item label {
      font-size: 16px;
      color: #2c3e50;
      cursor: pointer;
      font-weight: 500;
      flex: 1;
      line-height: 1.5;
    }
    
    .btn-submit {
      display: block;
      width: 100%;
      background: #3498db;
      color: white;
      border: none;
      padding: 18px;
      border-radius: 12px;
      font-size: 17px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: 0 4px 15px rgba(52, 152, 219, 0.2);
    }
    
    .btn-submit:hover {
      background: #2980b9;
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(52, 152, 219, 0.3);
    }
    
    .btn-submit:active {
      transform: translateY(0);
    }
    
    .note {
      text-align: center;
      margin-top: 25px;
      color: #7f8c8d;
      font-size: 14px;
      font-style: italic;
    }
    
    @media (max-width: 768px) {
      .container {
        margin: 30px 20px;
        padding: 30px 25px;
      }
      
      .header h1 {
        font-size: 28px;
      }
      
      .checkbox-item {
        padding: 15px 18px;
      }
      
      .checkbox-item label {
        font-size: 15px;
      }
    }
    
    @media (max-width: 480px) {
      .container {
        margin: 20px 15px;
        padding: 25px 20px;
      }
      
      .header h1 {
        font-size: 24px;
      }
      
      .header p {
        font-size: 14px;
      }
      
      .checkbox-item {
        padding: 12px 15px;
      }
      
      .btn-submit {
        padding: 16px;
        font-size: 16px;
      }
    }
  </style>
</head>
<body>

  <div class="container">
    <div class="header">
      <h1>Konsultasi Kondisi Kulit Wajah</h1>
      <p>Pilih gejala yang sesuai dengan kondisi kulit Anda</p>
    </div>
    
    <form method="POST" action="hasil_konsultasi.php" class="consultation-form">
      <div class="form-title">Gejala yang Anda Alami</div>
      
      <div class="checkbox-group">
        <div class="checkbox-item">
          <input type="checkbox" name="gejala[]" value="kering" id="kering">
          <label for="kering">Kulit terasa kering</label>
        </div>
        
        <div class="checkbox-item">
          <input type="checkbox" name="gejala[]" value="berminyak" id="berminyak">
          <label for="berminyak">Kulit berminyak</label>
        </div>
        
        <div class="checkbox-item">
          <input type="checkbox" name="gejala[]" value="berjerawat" id="berjerawat">
          <label for="berjerawat">Mudah berjerawat</label>
        </div>
        
        <div class="checkbox-item">
          <input type="checkbox" name="gejala[]" value="kusam" id="kusam">
          <label for="kusam">Kulit kusam</label>
        </div>
        
        <div class="checkbox-item">
          <input type="checkbox" name="gejala[]" value="sensitif" id="sensitif">
          <label for="sensitif">Kulit sensitif</label>
        </div>
        
        <div class="checkbox-item">
          <input type="checkbox" name="gejala[]" value="mengelupas" id="mengelupas">
          <label for="mengelupas">Kulit mengelupas</label>
        </div>
      </div>
      
      <button class="btn-submit" type="submit">
        Proses Diagnosa
      </button>
    </form>
    
    <div class="note">
      Pilih minimal satu gejala untuk mendapatkan rekomendasi treatment terbaik
    </div>
  </div>

</body>
</html>