<?php
if (!isset($_POST['gejala'])) {
  echo "<script>alert('Pilih minimal satu gejala terlebih dahulu!'); history.back();</script>";
  exit;
}

$gejala = $_POST['gejala'];

// DATA KRITERIA SAW (sesuai tabel pertama)
$kriteria = [
    'harga' => ['bobot' => 20, 'jenis' => 'cost'],    // C1
    'durasi' => ['bobot' => 15, 'jenis' => 'cost'],   // C2
    'hasil' => ['bobot' => 30, 'jenis' => 'benefit'], // C3
    'kepuasan' => ['bobot' => 20, 'jenis' => 'benefit'], // C4
    'keamanan' => ['bobot' => 15, 'jenis' => 'benefit']  // C5
];

// DATA TREATMENT DENGAN HARGA BARU (sesuai gambar terbaru)
$treatments = [
    'Facial Detox' => [
        'harga' => 120000,      // Rp 120.000
        'durasi' => 75,
        'hasil' => 80,
        'kepuasan' => 85,
        'keamanan' => 90,
        'deskripsi' => 'Membersihkan pori-pori dan mengangkat racun penyebab jerawat'
    ],
    'Facial Brightening' => [
        'harga' => 130000,      // Rp 130.000
        'durasi' => 70,
        'hasil' => 80,
        'kepuasan' => 85,
        'keamanan' => 90,
        'deskripsi' => 'Mencerahkan wajah kusam dan menyamarkan noda hitam'
    ],
    'Facial Hydrating' => [
        'harga' => 110000,      // Rp 110.000
        'durasi' => 60,
        'hasil' => 85,
        'kepuasan' => 90,
        'keamanan' => 95,
        'deskripsi' => 'Mengembalikan kelembapan kulit kering agar tampak segar'
    ],
    'Facial Anti-Acne' => [
        'harga' => 90000,       // Rp 90.000
        'durasi' => 80,
        'hasil' => 70,
        'kepuasan' => 75,
        'keamanan' => 85,
        'deskripsi' => 'Meredakan jerawat aktif dan menenangkan kulit berminyak'
    ],
    'Facial Anti-Aging' => [
        'harga' => 100000,      // Rp 100.000
        'durasi' => 90,
        'hasil' => 75,
        'kepuasan' => 80,
        'keamanan' => 85,
        'deskripsi' => 'Mengurangi garis halus dan menjaga keremajaan alami'
    ]
];

// MAPPING GEJALA KE TREATMENT
$rekomendasi_based_on_gejala = [];

foreach ($gejala as $g) {
    switch ($g) {
        case 'kering':
        case 'mengelupas':
        case 'sensitif':
            $rekomendasi_based_on_gejala['Facial Hydrating'] = true;
            break;
        case 'berminyak':
        case 'berjerawat':
            $rekomendasi_based_on_gejala['Facial Anti-Acne'] = true;
            $rekomendasi_based_on_gejala['Facial Detox'] = true;
            break;
        case 'kusam':
            $rekomendasi_based_on_gejala['Facial Brightening'] = true;
            break;
        default:
            // Jika gejala tidak dikenal, masukkan semua treatment
            foreach ($treatments as $nama => $data) {
                $rekomendasi_based_on_gejala[$nama] = true;
            }
    }
}

// Jika tidak ada yang cocok, ambil semua treatment
if (empty($rekomendasi_based_on_gejala)) {
    foreach ($treatments as $nama => $data) {
        $rekomendasi_based_on_gejala[$nama] = true;
    }
}

// Filter treatment yang sesuai gejala
$filtered_treatments = [];
foreach ($treatments as $nama => $data) {
    if (isset($rekomendasi_based_on_gejala[$nama])) {
        $filtered_treatments[$nama] = $data;
    }
}

// ===== PERHITUNGAN SAW =====
// 1. Cari nilai MAX dan MIN untuk normalisasi
$max_min = [];
foreach ($kriteria as $kode => $data_kriteria) {
    $values = array_column($filtered_treatments, $kode);
    
    if ($data_kriteria['jenis'] == 'benefit') {
        $max_min[$kode] = [
            'max' => max($values),
            'type' => 'benefit'
        ];
    } else { // cost
        $max_min[$kode] = [
            'min' => min($values),
            'type' => 'cost'
        ];
    }
}

// 2. Normalisasi dan Hitung Skor SAW
$hasil_saw = [];
foreach ($filtered_treatments as $nama => $data_treatment) {
    $skor_total = 0;
    
    foreach ($kriteria as $kode => $data_kriteria) {
        $nilai = $data_treatment[$kode];
        $bobot = $data_kriteria['bobot'] / 100; // konversi ke desimal
        
        if ($data_kriteria['jenis'] == 'benefit') {
            // Benefit: nilai / max
            $normalisasi = $nilai / $max_min[$kode]['max'];
        } else {
            // Cost: min / nilai
            $normalisasi = $max_min[$kode]['min'] / $nilai;
        }
        
        $skor_total += ($normalisasi * $bobot);
    }
    
    $hasil_saw[$nama] = [
        'skor' => $skor_total * 100, // konversi ke persen
        'data' => $data_treatment
    ];
}

// 3. Urutkan dari skor tertinggi ke terendah
arsort($hasil_saw);

// 4. Ambil rekomendasi terbaik (skor tertinggi)
$best_treatment = array_key_first($hasil_saw);
$best_data = $hasil_saw[$best_treatment];
$skor_terbaik = number_format($best_data['skor'], 2);
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Hasil Rekomendasi - Mahera Beauty</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
      background-color: #ffffff;
      color: #333333;
      line-height: 1.6;
    }
    
    .container {
      max-width: 800px;
      margin: 0 auto;
      padding: 20px;
    }
    
    .header {
      text-align: center;
      margin-bottom: 40px;
      padding-bottom: 20px;
      border-bottom: 1px solid #f0f0f0;
    }
    
    .header h1 {
      font-size: 28px;
      color: #2c3e50;
      font-weight: 600;
      margin-bottom: 10px;
      letter-spacing: -0.5px;
    }
    
    .gejala-list {
      background: #f8f9fa;
      padding: 16px 20px;
      border-radius: 10px;
      margin-bottom: 30px;
      font-size: 15px;
      color: #555;
    }
    
    .recommendation-card {
      background: #ffffff;
      border-radius: 16px;
      padding: 32px;
      margin-bottom: 40px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
      border: 1px solid #f0f0f0;
    }
    
    .recommendation-title {
      font-size: 24px;
      color: #2c3e50;
      margin-bottom: 16px;
      font-weight: 600;
    }
    
    .treatment-name {
      font-size: 32px;
      color: #3498db;
      margin-bottom: 20px;
      font-weight: 700;
      letter-spacing: -0.5px;
    }
    
    .treatment-price {
      font-size: 24px;
      color: #2c3e50;
      margin-bottom: 25px;
      font-weight: 600;
      background: #f8f9fa;
      padding: 12px 20px;
      border-radius: 8px;
      display: inline-block;
    }
    
    .score-badge {
      display: inline-block;
      background: linear-gradient(135deg, #3498db, #2980b9);
      color: white;
      padding: 10px 24px;
      border-radius: 50px;
      font-weight: 600;
      font-size: 18px;
      margin-bottom: 25px;
      margin-left: 15px;
      box-shadow: 0 4px 12px rgba(52, 152, 219, 0.2);
    }
    
    .description {
      font-size: 16px;
      color: #555;
      line-height: 1.7;
      margin-bottom: 32px;
      padding-bottom: 25px;
      border-bottom: 1px solid #f0f0f0;
    }
    
    .details-title {
      font-size: 18px;
      color: #2c3e50;
      margin-bottom: 20px;
      font-weight: 600;
    }
    
    .details-table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 30px;
    }
    
    .details-table th {
      background: #f8f9fa;
      padding: 16px 20px;
      text-align: left;
      font-weight: 600;
      color: #2c3e50;
      border-bottom: 1px solid #e9ecef;
      font-size: 15px;
    }
    
    .details-table td {
      padding: 16px 20px;
      border-bottom: 1px solid #f0f0f0;
      color: #555;
      font-size: 15px;
    }
    
    .details-table tr:last-child td {
      border-bottom: none;
    }
    
    .btn-booking {
      display: block;
      width: 100%;
      background: #3498db;
      color: white;
      text-align: center;
      padding: 18px;
      border-radius: 12px;
      font-size: 16px;
      font-weight: 600;
      text-decoration: none;
      transition: all 0.3s ease;
      border: none;
      cursor: pointer;
      margin-top: 30px;
      box-shadow: 0 4px 15px rgba(52, 152, 219, 0.2);
    }
    
    .btn-booking:hover {
      background: #2980b9;
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(52, 152, 219, 0.3);
    }
    
    .back-link {
      display: inline-block;
      text-align: center;
      color: #7f8c8d;
      text-decoration: none;
      font-size: 15px;
      margin-top: 30px;
      padding: 12px 0;
      width: 100%;
      border-radius: 8px;
      transition: all 0.3s ease;
    }
    
    .back-link:hover {
      color: #3498db;
      background: #f8f9fa;
    }
    
    @media (max-width: 768px) {
      .container {
        padding: 15px;
      }
      
      .recommendation-card {
        padding: 24px;
      }
      
      .treatment-name {
        font-size: 28px;
      }
      
      .treatment-price {
        font-size: 20px;
        display: block;
        margin-bottom: 15px;
      }
      
      .score-badge {
        margin-left: 0;
        display: block;
      }
      
      .details-table th,
      .details-table td {
        padding: 12px 15px;
      }
    }
  </style>
</head>
<body>

<div class="container">
  <div class="header">
    <h1>REKOMENDASI TERBAIK</h1>
  </div>
  
  <div class="gejala-list">
    <strong>Gejala yang dipilih:</strong>
    <?php 
    $gejala_text = implode(', ', array_map('ucfirst', $gejala));
    echo htmlspecialchars($gejala_text);
    ?>
  </div>
  
  <div class="recommendation-card">
    <div class="recommendation-title">Treatment Terpilih</div>
    <div class="treatment-name"><?php echo htmlspecialchars($best_treatment); ?></div>
    
    <div class="treatment-price">
      Rp <?php echo number_format($best_data['data']['harga'], 0, ',', '.'); ?>
    </div>
    
    <div class="score-badge">Skor SAW: <?php echo htmlspecialchars($skor_terbaik); ?>%</div>
    
    <div class="description">
      <?php echo htmlspecialchars($best_data['data']['deskripsi']); ?>
    </div>
    
    <div class="details-title">Detail Nilai Treatment</div>
    <table class="details-table">
      <tr>
        <th>Kriteria</th>
        <th>Nilai</th>
        <th>Bobot</th>
        <th>Jenis</th>
      </tr>
      <tr>
        <td>Harga</td>
        <td>Rp <?php echo number_format($best_data['data']['harga'], 0, ',', '.'); ?></td>
        <td>20%</td>
        <td>Cost</td>
      </tr>
      <tr>
        <td>Durasi</td>
        <td><?php echo htmlspecialchars($best_data['data']['durasi']); ?> menit</td>
        <td>15%</td>
        <td>Cost</td>
      </tr>
      <tr>
        <td>Hasil</td>
        <td><?php echo htmlspecialchars($best_data['data']['hasil']); ?>%</td>
        <td>30%</td>
        <td>Benefit</td>
      </tr>
      <tr>
        <td>Kepuasan</td>
        <td><?php echo htmlspecialchars($best_data['data']['kepuasan']); ?>%</td>
        <td>20%</td>
        <td>Benefit</td>
      </tr>
      <tr>
        <td>Keamanan</td>
        <td><?php echo htmlspecialchars($best_data['data']['keamanan']); ?>%</td>
        <td>15%</td>
        <td>Benefit</td>
      </tr>
    </table>
    
    <!-- TOMBOL DIALIHKAN KE RESERVASI.PHP -->
    <a href="reservasi.php?treatment=<?php echo urlencode($best_treatment); ?>&harga=<?php echo $best_data['data']['harga']; ?>" class="btn-booking">
      Reservasi Sekarang
    </a>
  </div>
  
  <a href="dashboard.php" class="back-link">← Kembali ke Beranda</a>
</div>

</body>
</html>