<?php
include '../koneksi.php';
session_start();

// Cek login admin
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

// Tambah data gejala
if (isset($_POST['tambah'])) {
  $nama = trim($_POST['nama']);
  if ($nama != '') {
    $nama = mysqli_real_escape_string($conn, $nama);
    mysqli_query($conn, "INSERT INTO gejala (nama) VALUES ('$nama')");
    header("Location: gejala.php");
    exit;
  }
}

// Hapus data gejala
if (isset($_GET['hapus'])) {
  $id = (int)$_GET['hapus'];
  mysqli_query($conn, "DELETE FROM gejala WHERE id_gejala='$id'");
  header("Location: gejala.php");
  exit;
}

// Edit data gejala
if (isset($_POST['update'])) {
  $id = (int)$_POST['id'];
  $nama = trim($_POST['nama']);
  $nama = mysqli_real_escape_string($conn, $nama);
  mysqli_query($conn, "UPDATE gejala SET nama='$nama' WHERE id_gejala='$id'");
  header("Location: gejala.php");
  exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Data Gejala</title>
  <style>
    body {
      background-color: #fff3ea;
      font-family: Arial, sans-serif;
      color: #4b2e05;
      margin: 0;
      padding: 0;
    }
    .container {
      width: 90%;
      max-width: 900px;
      background: #fff;
      margin: 40px auto;
      padding: 30px;
      border-radius: 16px;
      box-shadow: 0 6px 18px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #6e3b00;
      margin-bottom: 20px;
    }
    .btn, .btn-edit, .btn-back {
      background-color: #a86b2d;
      color: #fff;
      border: none;
      border-radius: 8px;
      padding: 8px 16px;
      cursor: pointer;
      text-decoration: none;
      font-weight: bold;
    }
    .btn:hover, .btn-edit:hover, .btn-back:hover {
      background-color: #7a4f1f;
    }
    .btn-back {
      display: inline-block;
      margin-bottom: 10px;
    }
    .form-tambah {
      display: flex;
      gap: 10px;
      margin-bottom: 20px;
    }
    .form-tambah input {
      flex: 1;
      padding: 8px;
      border: 1px solid #ddd;
      border-radius: 6px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }
    th {
      background-color: #f3e1cc;
      color: #6e3b00;
      padding: 10px;
    }
    td {
      padding: 10px;
      text-align: center;
      border-top: 1px solid #f1d8b8;
    }
    .hapus {
      color: purple;
      text-decoration: none;
      margin-left: 8px;
      font-weight: bold;
    }
    .hapus:hover {
      text-decoration: underline;
    }
    .modal {
      display: none;
      justify-content: center;
      align-items: center;
      position: fixed;
      inset: 0;
      background-color: rgba(0,0,0,0.3);
    }
    .modal-content {
      background: #fff;
      padding: 20px;
      border-radius: 12px;
      width: 300px;
    }
    .modal-content input {
      width: 100%;
      padding: 8px;
      margin: 10px 0;
      border-radius: 6px;
      border: 1px solid #ccc;
    }
    .modal-buttons {
      display: flex;
      justify-content: space-between;
    }
    .btn-cancel {
      background-color: #ccc;
      color: #333;
      border: none;
      border-radius: 8px;
      padding: 8px 16px;
      cursor: pointer;
    }
    @media (max-width: 600px) {
      .form-tambah {
        flex-direction: column;
      }
      .btn, .btn-edit, .btn-back {
        width: 100%;
        text-align: center;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>Data Gejala</h2>
    <a href="dashboard.php" class="btn-back">← Kembali</a>

    <form method="POST" class="form-tambah">
      <input type="text" name="nama" placeholder="Nama gejala" required>
      <button type="submit" name="tambah" class="btn">Tambah</button>
    </form>

    <table>
      <tr>
        <th>ID</th>
        <th>Nama</th>
        <th>Aksi</th>
      </tr>
      <?php
      $result = mysqli_query($conn, "SELECT * FROM gejala ORDER BY id_gejala DESC");
      if (!$result) {
        echo "<tr><td colspan='3'>Query error: " . mysqli_error($conn) . "</td></tr>";
      } elseif (mysqli_num_rows($result) == 0) {
        echo "<tr><td colspan='3'>Belum ada data gejala.</td></tr>";
      } else {
        while ($row = mysqli_fetch_assoc($result)) {
          echo "<tr>
                  <td>{$row['id_gejala']}</td>
                  <td>" . htmlspecialchars($row['nama']) . "</td>
                  <td>
                    <button class='btn-edit' onclick=\"editGejala({$row['id_gejala']}, '" . htmlspecialchars($row['nama'], ENT_QUOTES) . "')\">Edit</button>
                    <a href='gejala.php?hapus={$row['id_gejala']}' class='hapus' onclick=\"return confirm('Hapus gejala ini?')\">Hapus</a>
                  </td>
                </tr>";
        }
      }
      ?>
    </table>
  </div>

  <!-- Modal Edit -->
  <div id="editModal" class="modal">
    <div class="modal-content">
      <h3>Edit Gejala</h3>
      <form method="POST">
        <input type="hidden" name="id" id="editId">
        <input type="text" name="nama" id="editNama" required>
        <div class="modal-buttons">
          <button type="submit" name="update" class="btn">Simpan</button>
          <button type="button" class="btn-cancel" onclick="closeModal()">Batal</button>
        </div>
      </form>
    </div>
  </div>

  <script>
    function editGejala(id, nama) {
      document.getElementById('editId').value = id;
      document.getElementById('editNama').value = nama;
      document.getElementById('editModal').style.display = 'flex';
    }
    function closeModal() {
      document.getElementById('editModal').style.display = 'none';
    }
  </script>
</body>
</html>
