<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['admin'])) {
    header('Location: login.php');
    exit;
}

$table = $_GET['table'] ?? '';
$id = $_GET['id'] ?? '';

if ($table !== 'treatment' || empty($id)) {
    header('Location: treatment.php');
    exit;
}

$query = mysqli_query($conn, "SELECT * FROM treatment WHERE id='$id'");
if (!$query || mysqli_num_rows($query) == 0) {
    header("Location: treatment.php");
    exit;
}

$data = mysqli_fetch_assoc($query);

function proc($v){
    return ($v <= 1) ? $v * 100 : $v;
}

$nama   = htmlspecialchars($data['nama']);
$harga  = $data['harga'];
$ket    = htmlspecialchars($data['keterangan']);
$image  = $data['image'];

$harga_score     = proc($data['harga_score']);
$durasi_score    = proc($data['durasi_score']);
$hasil_score     = proc($data['hasil_score']);
$kepuasan_score  = proc($data['kepuasan_score']);
$aman_score      = proc($data['aman_score']);

$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    function saveValue($v) {
        return max(0, min(1, round(($v > 1 ? $v/100 : $v), 2)));
    }

    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $harga = (int)$_POST['harga'];
    $ket = mysqli_real_escape_string($conn, $_POST['keterangan']);

    $h_s   = saveValue($_POST['harga_score']);
    $d_s   = saveValue($_POST['durasi_score']);
    $hs_s  = saveValue($_POST['hasil_score']);
    $kp_s  = saveValue($_POST['kepuasan_score']);
    $am_s  = saveValue($_POST['aman_score']);

    $newImg = $image;
    if (!empty($_FILES['image']['tmp_name'])) {
        $newImg = time() . "_" . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], "../images/" . $newImg);
    }

    $sql = "UPDATE treatment SET 
            nama='$nama',
            harga='$harga',
            keterangan='$ket',
            harga_score='$h_s',
            durasi_score='$d_s',
            hasil_score='$hs_s',
            kepuasan_score='$kp_s',
            aman_score='$am_s',
            image='$newImg'
            WHERE id='$id'";

    if (mysqli_query($conn, $sql)) {
        $_SESSION['success'] = "Treatment berhasil diperbarui!";
        header("Location: treatment.php");
        exit;
    } else {
        $error = "Gagal update database!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Edit Treatment</title>

<style>
body {
    background: #f7f9fc;
    font-family: Arial;
    padding: 20px;
}

.container {
    max-width: 750px;
    margin: auto;
    background: white;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

label { font-weight: bold; margin-top: 15px; display: block; }

input, textarea {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 6px;
}

.sliderBox {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    border: 1px solid #eee;
    margin-bottom: 20px;
}

.slider-value {
    display: flex;
    justify-content: center;
    margin-top: 5px;
    font-weight: bold;
    background: #3498db;
    width: 60px;
    margin-left: auto;
    margin-right: auto;
    padding: 5px;
    border-radius: 20px;
    color: white;
}

.range {
    width: 100%;
}

.small-labels {
    display: flex;
    justify-content: space-between;
    font-size: 12px;
    margin-top: 3px;
}
button {
    width: 100%;
    padding: 12px;
    border: none;
    background: #3498db;
    color: white;
    font-size: 17px;
    border-radius: 8px;
    cursor: pointer;
}
button:hover { background: #2980b9; }

.img-preview {
    width: 120px;
    border-radius: 10px;
    margin-top: 10px;
}
</style>

</head>
<body>

<div class="container">

<h2>Edit Treatment</h2>

<?php if ($error): ?>
<div style="color: red;"><?= $error ?></div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data">

    <label>Nama Treatment</label>
    <input type="text" name="nama" value="<?= $nama ?>" required>

    <label>Harga</label>
    <input type="number" name="harga" value="<?= $harga ?>" required>

    <label>Keterangan</label>
    <textarea name="keterangan" rows="3"><?= $ket ?></textarea>

    <!-- SLIDER LIST -->
    <?php 
    $sl = [
        "harga_score" => ["Mahal (0%)", "Murah (100%)", $harga_score],
        "durasi_score" => ["Lama (0%)", "Cepat (100%)", $durasi_score],
        "hasil_score" => ["Buruk (0%)", "Bagus (100%)", $hasil_score],
        "kepuasan_score" => ["Rendah (0%)", "Tinggi (100%)", $kepuasan_score],
        "aman_score" => ["Tidak Aman (0%)", "Aman (100%)", $aman_score],
    ];

    foreach ($sl as $name => $info):
    ?>
        <div class="sliderBox">
            <label><?= ucwords(str_replace("_", " ", $name)) ?> (0-100%)</label>

            <input class="range" type="range" min="0" max="100" 
                name="<?= $name ?>" 
                value="<?= $info[2] ?>"
                oninput="document.getElementById('v_<?= $name ?>').innerText = this.value + '%'">

            <div class="small-labels">
                <span><?= $info[0] ?></span>
                <span><?= $info[1] ?></span>
            </div>

            <div class="slider-value" id="v_<?= $name ?>"><?= $info[2] ?>%</div>
        </div>
    <?php endforeach; ?>

    <label>Gambar (opsional)</label>
    <input type="file" name="image">

    <?php if ($image): ?>
        <img src="../images/<?= $image ?>" class="img-preview">
    <?php endif; ?>

    <button type="submit">Simpan Perubahan</button>

</form>
</div>

</body>
</html>
