<?php
session_start();

// Cek login admin
if (!isset($_SESSION['admin'])) {
    header('Location: login.php');
    exit;
}

// Inisialisasi variabel
$total_treatment = 0;
$total_testimoni = 0;
$notif_count = 0;
$testimoni_pending_count = 0;
$using_real_data = false;

// Data treatment
$treatments = [
    ['name' => 'Facial Anti-Aging', 'icon' => 'fas fa-user-clock', 'color' => '#a86b2d'],
    ['name' => 'Facial Anti-Acne', 'icon' => 'fas fa-leaf', 'color' => '#7a4f1f'],
    ['name' => 'Facial Hydrating', 'icon' => 'fas fa-tint', 'color' => '#6e3b00'],
    ['name' => 'Facial Brightening', 'icon' => 'fas fa-sun', 'color' => '#a86b2d'],
    ['name' => 'Facial Detox', 'icon' => 'fas fa-recycle', 'color' => '#7a4f1f']
];

// Data untuk grafik - inisialisasi
$labels_treatment = ['Facial Anti-Aging', 'Facial Anti-Acne', 'Facial Hydrating', 'Facial Brightening', 'Facial Detox'];
$data_treatment = [35, 25, 20, 15, 5];
$bulan_labels = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];
$bulan_data = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

// Coba koneksi database
try {
    if (file_exists('../koneksi.php')) {
        include '../koneksi.php';
        
        // Gunakan $conn dari koneksi.php Anda
        if (isset($conn) && $conn !== false) {
            $using_real_data = true;
            
            // DEBUG: Tampilkan info koneksi
            echo "<!-- Database connected: " . mysqli_get_host_info($conn) . " -->";
            
            // Query untuk total treatment
            $result = mysqli_query($conn, "SELECT COUNT(*) as total FROM treatment");
            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $total_treatment = $row['total'];
                echo "<!-- Total treatment: $total_treatment -->";
            }
            
            // Query untuk total testimoni
            $result = mysqli_query($conn, "SELECT COUNT(*) as total FROM testimoni");
            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $total_testimoni = $row['total'];
                echo "<!-- Total testimoni: $total_testimoni -->";
            }
            
            // Query untuk testimoni pending
            $result = mysqli_query($conn, "SELECT COUNT(*) as total FROM testimoni WHERE approved = 0");
            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $testimoni_pending_count = $row['total'];
                echo "<!-- Testimoni pending: $testimoni_pending_count -->";
            }
            
            // **QUERY RESERVASI - PERBAIKAN**
            // Cek dulu apakah tabel reservasi ada dan punya data
            $result = mysqli_query($conn, "SHOW TABLES LIKE 'reservasi'");
            if (mysqli_num_rows($result) > 0) {
                echo "<!-- Table reservasi exists -->";
                
                // Query untuk reservasi baru - coba beberapa kemungkinan kolom status
                $queries = [
                    "SELECT COUNT(*) as total FROM reservasi WHERE status = 'pending'",
                    "SELECT COUNT(*) as total FROM reservasi WHERE status = 'menunggu'", 
                    "SELECT COUNT(*) as total FROM reservasi WHERE status = 'baru'",
                    "SELECT COUNT(*) as total FROM reservasi WHERE status = 'waiting'",
                    "SELECT COUNT(*) as total FROM reservasi" // Jika tidak ada status, hitung semua
                ];
                
                foreach ($queries as $query) {
                    $result = mysqli_query($conn, $query);
                    if ($result) {
                        $row = mysqli_fetch_assoc($result);
                        $count = $row['total'];
                        echo "<!-- Query: $query = $count -->";
                        if ($count > 0) {
                            $notif_count = $count;
                            break;
                        }
                    }
                }
                
                echo "<!-- Final notif_count: $notif_count -->";
                
                // **STATISTIK REAL RESERVASI**
                $current_year = date('Y');
                
                // Cek struktur tabel reservasi
                $result = mysqli_query($conn, "DESCRIBE reservasi");
                $columns = [];
                while ($row = mysqli_fetch_assoc($result)) {
                    $columns[] = $row['Field'];
                }
                echo "<!-- Reservasi columns: " . implode(', ', $columns) . " -->";
                
                // Coba beberapa kemungkinan nama kolom tanggal
                $date_columns = ['tanggal_reservasi', 'reservation_date', 'date', 'created_at', 'tanggal'];
                $date_column_found = null;
                
                foreach ($date_columns as $col) {
                    if (in_array($col, $columns)) {
                        $date_column_found = $col;
                        break;
                    }
                }
                
                if ($date_column_found) {
                    echo "<!-- Using date column: $date_column_found -->";
                    
                    $result = mysqli_query($conn, "
                        SELECT 
                            MONTH($date_column_found) as bulan,
                            COUNT(*) as jumlah
                        FROM reservasi 
                        WHERE YEAR($date_column_found) = '$current_year'
                        GROUP BY MONTH($date_column_found)
                        ORDER BY bulan
                    ");
                    
                    if ($result && mysqli_num_rows($result) > 0) {
                        $bulan_data = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
                        
                        while ($row = mysqli_fetch_assoc($result)) {
                            $bulan_index = $row['bulan'] - 1;
                            $bulan_data[$bulan_index] = $row['jumlah'];
                            echo "<!-- Month {$row['bulan']}: {$row['jumlah']} reservations -->";
                        }
                    } else {
                        echo "<!-- No reservation data found for year $current_year -->";
                    }
                } else {
                    echo "<!-- No date column found in reservasi table -->";
                }
                
            } else {
                echo "<!-- Table reservasi does not exist -->";
            }
            
        }
    }
} catch (Exception $e) {
    $using_real_data = false;
    echo "<!-- Error: " . $e->getMessage() . " -->";
}

// Jika koneksi gagal, gunakan data statis
if (!$using_real_data) {
    $total_treatment = 5;
    $total_testimoni = 5;
    $testimoni_pending_count = 2;
    $notif_count = 0;
    
    // Data statis untuk demo
    $bulan_data = [3, 5, 7, 2, 8, 4, 6, 9, 5, 3, 7, 8];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Dashboard Admin - Treatment Mahera</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* CSS tetap sama seperti sebelumnya */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background-color: #fff7f0;
            font-family: Arial, sans-serif;
            color: #4b2e05;
            display: flex;
            min-height: 100vh;
        }

        .sidebar {
            width: 250px;
            background: linear-gradient(135deg, #a86b2d, #7a4f1f);
            color: white;
            padding: 20px 0;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            box-shadow: 3px 0 10px rgba(0,0,0,0.1);
        }

        .logo {
            text-align: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255,255,255,0.2);
            margin-bottom: 20px;
        }

        .logo h2 {
            color: white;
            font-size: 1.5rem;
        }

        .nav-menu {
            list-style: none;
            padding: 0 15px;
        }

        .nav-item {
            margin-bottom: 8px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 12px 15px;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s;
            position: relative;
        }

        .nav-link:hover {
            background: rgba(255,255,255,0.1);
            transform: translateX(5px);
        }

        .nav-link.active {
            background: rgba(255,255,255,0.2);
        }

        .nav-icon {
            width: 25px;
            margin-right: 12px;
            text-align: center;
        }

        .notif-badge {
            background-color: #e74c3c;
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 11px;
            font-weight: bold;
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: translateY(-50%) scale(1); }
            50% { transform: translateY(-50%) scale(1.1); }
            100% { transform: translateY(-50%) scale(1); }
        }

        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 30px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 15px;
            border-bottom: 1px solid #e0d6c8;
        }

        .welcome h1 {
            color: #6e3b00;
            font-size: 1.8rem;
        }

        .welcome p {
            color: #7a4f1f;
            margin-top: 5px;
        }

        .logout-btn {
            background-color: #a86b2d;
            color: #fff;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: bold;
            transition: 0.3s;
            display: inline-block;
        }

        .logout-btn:hover {
            background-color: #7a4f1f;
        }

        .stats-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background-color: #fff;
            border-radius: 12px;
            padding: 25px;
            text-align: center;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            transition: transform 0.3s;
            position: relative;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-icon {
            font-size: 2.5rem;
            color: #a86b2d;
            margin-bottom: 15px;
        }

        .stat-number {
            font-size: 28px;
            font-weight: bold;
            color: #a86b2d;
            margin: 10px 0;
        }

        .stat-label {
            font-size: 14px;
            color: #7a4f1f;
        }

        .stat-badge {
            position: absolute;
            top: 15px;
            right: 15px;
            background: #e74c3c;
            color: white;
            border-radius: 12px;
            padding: 3px 8px;
            font-size: 11px;
            font-weight: bold;
            animation: pulse 2s infinite;
        }

        .treatment-section {
            background: #fff;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            margin-bottom: 30px;
        }

        .section-title {
            color: #6e3b00;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0e6d8;
            font-size: 1.4rem;
        }

        .treatment-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 20px;
        }

        .treatment-card {
            background: #f8f1e8;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            transition: all 0.3s;
            border-left: 4px solid #a86b2d;
        }

        .treatment-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        }

        .treatment-icon {
            font-size: 2rem;
            margin-bottom: 15px;
            color: #a86b2d;
        }

        .treatment-name {
            font-weight: bold;
            color: #6e3b00;
            font-size: 1rem;
        }

        .charts-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .chart-box {
            background-color: #fff;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        }

        .chart-title {
            text-align: center;
            margin-bottom: 15px;
            color: #6e3b00;
            font-weight: bold;
            font-size: 1.2rem;
        }

        .chart-subtitle {
            text-align: center;
            margin-bottom: 20px;
            color: #7a4f1f;
            font-size: 0.9rem;
        }

        .alert {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            color: #856404;
        }

        .success-alert {
            background: #d1edff;
            border: 1px solid #b3d9ff;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            color: #004085;
        }

        .refresh-btn {
            background: #a86b2d;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            margin-left: 10px;
        }

        .refresh-btn:hover {
            background: #7a4f1f;
        }

        .debug-info {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 10px;
            margin-bottom: 20px;
            font-size: 12px;
            color: #6c757d;
        }

        @media (max-width: 992px) {
            .sidebar {
                width: 70px;
                overflow: visible;
            }
            .logo h2, .nav-text {
                display: none;
            }
            .nav-icon {
                margin-right: 0;
                font-size: 1.2rem;
            }
            .nav-link {
                justify-content: center;
                padding: 15px;
            }
            .main-content {
                margin-left: 70px;
            }
            .charts-container {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .treatment-grid {
                grid-template-columns: 1fr;
            }
            .stats-container {
                grid-template-columns: 1fr 1fr;
            }
        }

        @media (max-width: 576px) {
            .stats-container {
                grid-template-columns: 1fr;
            }
            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
        }
    </style>
</head>
<body>

    <!-- Sidebar Navigation -->
    <div class="sidebar">
        <div class="logo">
            <h2>Mahera Admin</h2>
        </div>
        <ul class="nav-menu">
            <li class="nav-item">
                <a href="treatment.php" class="nav-link active">
                    <i class="fas fa-spa nav-icon"></i>
                    <span class="nav-text">Treatment</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="bobot.php" class="nav-link">
                    <i class="fas fa-balance-scale nav-icon"></i>
                    <span class="nav-text">Bobot</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="testimoni.php" class="nav-link">
                    <i class="fas fa-comment-dots nav-icon"></i>
                    <span class="nav-text">Testimoni</span>
                    <?php if($testimoni_pending_count > 0): ?>
                        <span class="notif-badge"><?= $testimoni_pending_count ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a href="gejala.php" class="nav-link">
                    <i class="fas fa-stethoscope nav-icon"></i>
                    <span class="nav-text">Data Gejala</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="reservasi.php" class="nav-link">
                    <i class="fas fa-calendar-check nav-icon"></i>
                    <span class="nav-text">Reservasi</span>
                    <?php if($notif_count > 0): ?>
                        <span class="notif-badge"><?= $notif_count ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a href="konsultasi.php" class="nav-link">
                    <i class="fas fa-comments nav-icon"></i>
                    <span class="nav-text">Konsultasi</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="logout.php" class="nav-link">
                    <i class="fas fa-sign-out-alt nav-icon"></i>
                    <span class="nav-text">Logout</span>
                </a>
            </li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="header">
            <div class="welcome">
                <h1>Dashboard Treatment Mahera</h1>
                <p>Selamat datang, <strong><?= htmlspecialchars($_SESSION['admin']); ?></strong></p>
            </div>
            <div>
                <a href="logout.php" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
                <button class="refresh-btn" onclick="refreshDashboard()">
                    <i class="fas fa-sync-alt"></i> Refresh
                </button>
            </div>
        </div>

        <!-- Debug Info -->
        <div class="debug-info">
            <strong>Debug Info:</strong> 
            Reservasi Baru: <?= $notif_count ?> | 
            Testimoni Pending: <?= $testimoni_pending_count ?> |
            Data Source: <?= $using_real_data ? 'Database Real' : 'Data Statis' ?>
        </div>

        <!-- Alert Status Data -->
        <?php if($using_real_data): ?>
            <div class="success-alert">
                <i class="fas fa-check-circle"></i> 
                <strong>Berhasil!</strong> Dashboard menampilkan data real-time dari database.
                <small>Terakhir diperbarui: <?= date('H:i:s') ?> | Tahun: <?= date('Y') ?></small>
            </div>
        <?php else: ?>
            <div class="alert">
                <i class="fas fa-info-circle"></i> 
                <strong>Info:</strong> Dashboard menggunakan data statis. 
                <button class="refresh-btn" onclick="location.reload()">Coba Refresh</button>
            </div>
        <?php endif; ?>

        <!-- Statistics Cards (HANYA 3 SAJA) -->
        <div class="stats-container">
            <div class="stat-card">
                <i class="fas fa-spa stat-icon"></i>
                <div class="stat-number"><?= $total_treatment ?></div>
                <div class="stat-label">Total Treatment</div>
            </div>
            
            <div class="stat-card">
                <i class="fas fa-star stat-icon"></i>
                <div class="stat-number"><?= $total_testimoni ?></div>
                <div class="stat-label">Total Testimoni</div>
                <?php if($testimoni_pending_count > 0): ?>
                    <div class="stat-badge"><?= $testimoni_pending_count ?> Baru</div>
                <?php endif; ?>
            </div>
            
            <div class="stat-card">
                <i class="fas fa-bell stat-icon"></i>
                <div class="stat-number"><?= $notif_count ?></div>
                <div class="stat-label">Reservasi Baru</div>
                <?php if($notif_count > 0): ?>
                    <div class="stat-badge">Perlu Tindakan</div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Treatment List -->
        <div class="treatment-section">
            <h2 class="section-title">Daftar Treatment Tersedia</h2>
            <div class="treatment-grid">
                <?php foreach($treatments as $treatment): ?>
                <div class="treatment-card">
                    <i class="<?= $treatment['icon'] ?> treatment-icon"></i>
                    <div class="treatment-name"><?= $treatment['name'] ?></div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="charts-container">
            <div class="chart-box">
                <div class="chart-title">Statistik Treatment Terpopuler</div>
                <canvas id="treatmentChart"></canvas>
            </div>
            <div class="chart-box">
                <div class="chart-title">Statistik Reservasi Bulanan</div>
                <div class="chart-subtitle">Tahun <?= date('Y') ?></div>
                <canvas id="reservationChart"></canvas>
            </div>
        </div>
    </div>

    <script>
        function refreshDashboard() {
            location.reload();
        }

        // Auto-refresh setiap 30 detik
        setTimeout(function() {
            refreshDashboard();
        }, 30000);

        document.addEventListener('DOMContentLoaded', function() {
            // Data untuk grafik treatment
            const treatmentLabels = <?= json_encode($labels_treatment) ?>;
            const treatmentData = <?= json_encode($data_treatment) ?>;

            // Data untuk grafik reservasi bulanan - DATA REAL
            const bulanLabels = <?= json_encode($bulan_labels) ?>;
            const bulanData = <?= json_encode($bulan_data) ?>;

            // Grafik Treatment Terpopuler
            const treatmentCtx = document.getElementById('treatmentChart').getContext('2d');
            const treatmentChart = new Chart(treatmentCtx, {
                type: 'doughnut',
                data: {
                    labels: treatmentLabels,
                    datasets: [{
                        data: treatmentData,
                        backgroundColor: [
                            'rgba(168, 107, 45, 0.8)',
                            'rgba(122, 79, 31, 0.8)',
                            'rgba(110, 59, 0, 0.8)',
                            'rgba(75, 46, 5, 0.8)',
                            'rgba(56, 34, 3, 0.8)'
                        ],
                        borderColor: [
                            'rgb(168, 107, 45)',
                            'rgb(122, 79, 31)',
                            'rgb(110, 59, 0)',
                            'rgb(75, 46, 5)',
                            'rgb(56, 34, 3)'
                        ],
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }
            });

            // Grafik Reservasi Bulanan - DATA REAL
            const reservationCtx = document.getElementById('reservationChart').getContext('2d');
            const reservationChart = new Chart(reservationCtx, {
                type: 'bar',
                data: {
                    labels: bulanLabels,
                    datasets: [{
                        label: 'Jumlah Reservasi',
                        data: bulanData,
                        backgroundColor: 'rgba(168, 107, 45, 0.7)',
                        borderColor: 'rgb(168, 107, 45)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Jumlah Reservasi'
                            }
                        },
                        x: {
                            title: {
                                display: true,
                                text: 'Bulan'
                            }
                        }
                    }
                }
            });
        });
    </script>

</body>
</html>