<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['admin'])) {
  header('Location: login.php');
  exit;
}

// Data kriteria tetap - dalam persentase 0-100%
$fixed_kriteria = [
    'harga' => 20,
    'durasi' => 15, 
    'hasil' => 30,
    'kepuasan' => 20,
    'aman' => 15
];

$error = '';
$success = '';

// Reset ke bobot default
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['reset_bobot'])) {
    mysqli_query($conn, "DELETE FROM kriteria");
    
    foreach ($fixed_kriteria as $nama => $bobot) {
        $idk = 'C' . (array_search($nama, array_keys($fixed_kriteria)) + 1);
        $stmt = mysqli_prepare($conn, "INSERT INTO kriteria (id_kriteria, nama_kriteria, bobot) VALUES (?, ?, ?)");
        mysqli_stmt_bind_param($stmt, "ssd", $idk, $nama, $bobot);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
    
    header('Location: bobot.php');
    exit;
}

// Update bobot dari form
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_bobot'])) {
    $total = 0;
    
    // Hitung total dulu
    foreach ($_POST['bobot'] as $id => $value) {
        $total += floatval($value);
    }
    
    if ($total == 100) {
        // Update ke database
        foreach ($_POST['bobot'] as $id => $value) {
            $stmt = mysqli_prepare($conn, "UPDATE kriteria SET bobot = ? WHERE id_kriteria = ?");
            mysqli_stmt_bind_param($stmt, "ds", $value, $id);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);
        }
        $success = "Bobot berhasil diperbarui! Total: 100%";
    } else {
        $error = "Total bobot harus tepat 100%! Saat ini: " . $total . "%";
    }
}

// Cek jika tabel kriteria kosong, isi dengan data default
$check = mysqli_query($conn, "SELECT COUNT(*) as total FROM kriteria");
$row = mysqli_fetch_assoc($check);
if ($row['total'] == 0) {
    foreach ($fixed_kriteria as $nama => $bobot) {
        $idk = 'C' . (array_search($nama, array_keys($fixed_kriteria)) + 1);
        $stmt = mysqli_prepare($conn, "INSERT INTO kriteria (id_kriteria, nama_kriteria, bobot) VALUES (?, ?, ?)");
        mysqli_stmt_bind_param($stmt, "ssd", $idk, $nama, $bobot);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
}

$res = mysqli_query($conn, 'SELECT * FROM kriteria ORDER BY id_kriteria');

// Hitung total bobot
$total_bobot = 0;
$kriteria_data = [];
while ($row = mysqli_fetch_assoc($res)) {
  $total_bobot += $row['bobot'];
  $kriteria_data[] = $row;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <title>Admin - Bobot Kriteria</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    :root {
      --primary-brown: #5b4033;
      --secondary-brown: #8b5e3c;
      --light-brown: #a9744b;
      --accent-brown: #caa58a;
      --background: #fff8f5;
      --card-bg: #fff;
      --text-dark: #4b2e0f;
      --border-light: #efe9e4;
      --shadow: rgba(0, 0, 0, 0.08);
      --success: #28a745;
      --warning: #ffc107;
      --danger: #dc3545;
    }

    body {
      font-family: 'Poppins', Arial, sans-serif;
      background: var(--background);
      color: var(--text-dark);
      line-height: 1.6;
    }

    .container {
      width: 92%;
      max-width: 1000px;
      margin: 40px auto;
      background: var(--card-bg);
      padding: 24px;
      border-radius: 16px;
      box-shadow: 0 8px 24px var(--shadow);
      border: 1px solid var(--border-light);
    }

    h2 {
      text-align: center;
      color: var(--primary-brown);
      font-size: 1.8em;
      font-weight: 600;
      margin-bottom: 20px;
    }

    .btn {
      display: inline-block;
      background: var(--secondary-brown);
      color: #fff;
      padding: 8px 14px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 500;
      border: none;
      cursor: pointer;
      transition: background 0.3s ease, transform 0.2s ease;
      font-size: 14px;
    }

    .btn:hover {
      background: var(--light-brown);
      transform: translateY(-2px);
    }

    .btn-success {
      background: var(--success);
    }

    .btn-success:hover {
      background: #218838;
    }

    .btn-edit {
      background: #17a2b8;
    }

    .btn-edit:hover {
      background: #138496;
    }

    .total-info {
      background: #e8f5e8;
      border: 1px solid var(--success);
      border-radius: 8px;
      padding: 12px 16px;
      margin-bottom: 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .total-info .total-value {
      font-weight: 600;
      font-size: 1.1em;
    }

    .total-100 {
      color: var(--success);
    }

    .total-over {
      color: var(--danger);
    }

    .total-under {
      color: var(--warning);
    }

    .info-box {
      background: #e3f2fd;
      border: 1px solid #2196f3;
      border-radius: 8px;
      padding: 15px;
      margin-bottom: 20px;
    }

    .table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 10px;
    }

    .table th,
    .table td {
      padding: 12px 14px;
      border: 1px solid var(--border-light);
      text-align: center;
      vertical-align: middle;
    }

    .table th {
      background-color: var(--accent-brown);
      color: #fff;
      font-weight: 600;
    }

    .table td {
      background-color: #fffaf6;
      color: var(--text-dark);
    }

    .table tr:nth-child(even) td {
      background-color: #fdf3ed;
    }

    .bobot-input {
      width: 80px;
      padding: 10px;
      border: 2px solid #ddd;
      border-radius: 6px;
      text-align: center;
      font-size: 16px;
      font-weight: 600;
      color: var(--primary-brown);
    }

    .bobot-input:focus {
      border-color: var(--secondary-brown);
      outline: none;
      box-shadow: 0 0 0 3px rgba(139, 94, 60, 0.2);
    }

    .bobot-value {
      font-weight: 600;
      color: var(--primary-brown);
      font-size: 1.1em;
    }

    .action-buttons {
      display: flex;
      gap: 10px;
      margin-bottom: 20px;
      flex-wrap: wrap;
    }

    .fixed-criteria {
      background: #fff3cd;
      border: 1px solid #ffeaa7;
      border-radius: 8px;
      padding: 15px;
      margin-bottom: 20px;
    }

    .criteria-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
      gap: 15px;
      margin-top: 20px;
    }

    .criteria-card {
      background: white;
      border: 2px solid var(--accent-brown);
      border-radius: 10px;
      padding: 15px;
      text-align: center;
    }

    .criteria-value {
      font-size: 1.5em;
      font-weight: bold;
      color: var(--primary-brown);
      margin: 10px 0;
    }

    .criteria-name {
      font-weight: 600;
      color: var(--text-dark);
    }

    .visual-bar {
      background: #e0e0e0;
      border-radius: 10px;
      height: 25px;
      width: 100%;
      position: relative;
      overflow: hidden;
      margin: 10px 0;
    }

    .visual-fill {
      background: linear-gradient(90deg, var(--secondary-brown), var(--light-brown));
      height: 100%;
      border-radius: 10px;
      transition: width 0.5s ease;
    }

    .visual-text {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      color: #333;
      font-weight: bold;
      font-size: 0.9em;
    }

    .message {
      padding: 12px 16px;
      border-radius: 8px;
      margin-bottom: 20px;
      font-weight: 500;
    }

    .message-success {
      background: #d4edda;
      color: #155724;
      border: 1px solid #c3e6cb;
    }

    .message-error {
      background: #f8d7da;
      color: #721c24;
      border: 1px solid #f5c6cb;
    }

    .edit-form-container {
      background: #f9f9f9;
      padding: 15px;
      border-radius: 8px;
      margin-top: 20px;
      border: 1px solid #ddd;
    }

    .form-group {
      margin-bottom: 15px;
    }

    .form-group label {
      display: block;
      margin-bottom: 5px;
      font-weight: 600;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>📊 Manajemen Bobot Kriteria</h2>
    
    <div class="action-buttons">
      <a href="dashboard.php" class="btn">← Kembali ke Dashboard</a>
      <form method="post" style="display: inline;">
        <button type="submit" name="reset_bobot" class="btn btn-success" onclick="return confirm('Reset semua bobot ke nilai default?')">🔄 Reset ke Bobot Default</button>
      </form>
    </div>

    <?php if ($success): ?>
      <div class="message message-success">✅ <?php echo $success; ?></div>
    <?php endif; ?>
    
    <?php if ($error): ?>
      <div class="message message-error">❌ <?php echo $error; ?></div>
    <?php endif; ?>

    <!-- Info Bobot Default -->
    <div class="fixed-criteria">
      <h4>📋 Bobot Kriteria Default:</h4>
      <div class="criteria-grid">
        <?php foreach ($fixed_kriteria as $nama => $bobot): ?>
        <div class="criteria-card">
          <div class="criteria-name"><?php echo ucfirst($nama); ?></div>
          <div class="criteria-value"><?php echo $bobot; ?>%</div>
          <div class="visual-bar">
            <div class="visual-fill" style="width: <?php echo $bobot; ?>%;"></div>
            <div class="visual-text"><?php echo $bobot; ?>/100</div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
      <p style="text-align: center; margin-top: 15px; font-weight: bold;">
        <em>Total: 100/100</em>
      </p>
    </div>

    <!-- Info Total Bobot -->
    <div class="total-info">
      <span>📈 Total Bobot Saat Ini:</span>
      <span class="total-value 
        <?php 
        if ($total_bobot == 100) echo 'total-100';
        elseif ($total_bobot > 100) echo 'total-over';
        else echo 'total-under';
        ?>" id="total-display">
        <?= number_format($total_bobot, 0) ?> / 100
      </span>
    </div>

    <?php if ($total_bobot != 100): ?>
      <div class="info-box">
        <h3>⚠️ Perhatian!</h3>
        <p>Total bobot harus tepat <strong>100</strong> untuk sistem dapat bekerja dengan optimal. Gunakan tombol "Reset ke Bobot Default" untuk mengatur ulang ke nilai yang disarankan.</p>
      </div>
    <?php endif; ?>

    <!-- FORM UNTUK EDIT BOBOT -->
    <form method="POST" action="">
      <table class="table">
        <thead>
          <tr>
            <th width="10%">ID</th>
            <th width="20%">Kriteria</th>
            <th width="15%">Bobot (%)</th>
            <th width="35%">Visualisasi</th>
            <th width="20%">Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($kriteria_data)): ?>
            <?php foreach ($kriteria_data as $r): ?>
              <tr id="row-<?= htmlspecialchars($r['id_kriteria']); ?>">
                <td><strong><?= htmlspecialchars($r['id_kriteria']); ?></strong></td>
                <td><?= htmlspecialchars(ucfirst($r['nama_kriteria'])); ?></td>
                <td>
                  <input type="number" 
                         name="bobot[<?= htmlspecialchars($r['id_kriteria']); ?>]" 
                         class="bobot-input"
                         value="<?= number_format($r['bobot'], 0) ?>" 
                         min="0" 
                         max="100" 
                         step="1"
                         oninput="updateRowTotal(this, '<?= htmlspecialchars($r['id_kriteria']); ?>')">
                </td>
                <td>
                  <div class="visual-bar">
                    <div class="visual-fill" id="bar-<?= htmlspecialchars($r['id_kriteria']); ?>" 
                         style="width: <?= $r['bobot'] ?>%;"></div>
                    <div class="visual-text" id="text-<?= htmlspecialchars($r['id_kriteria']); ?>">
                      <?= number_format($r['bobot'], 0) ?> / 100
                    </div>
                  </div>
                </td>
                <td>
                  <button type="button" class="btn btn-edit" 
                          onclick="showEditForm('<?= htmlspecialchars($r['id_kriteria']); ?>', '<?= htmlspecialchars($r['nama_kriteria']); ?>')">
                    ✏️ Edit Nilai
                  </button>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="5" style="text-align: center; padding: 40px;">
                <p style="margin-bottom: 20px; color: #666;">Tidak ada data kriteria.</p>
                <form method="post">
                  <button type="submit" name="reset_bobot" class="btn btn-success" style="font-size: 16px; padding: 12px 20px;">
                    🚀 Buat Data Kriteria Default
                  </button>
                </form>
              </td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>

      <?php if (!empty($kriteria_data)): ?>
        <div style="text-align: center; margin-top: 20px;">
          <button type="submit" name="update_bobot" class="btn btn-success" style="font-size: 16px; padding: 12px 20px;">
            💾 Simpan Perubahan Bobot
          </button>
        </div>
      <?php endif; ?>
    </form>

    <!-- FORM UNTUK EDIT NILAI DETAIL (Modal/Popup) -->
    <div class="edit-form-container" id="edit-form" style="display: none;">
      <h3>✏️ Edit Nilai Kriteria</h3>
      <form id="detail-form">
        <div class="form-group">
          <label for="edit-kriteria">Kriteria:</label>
          <input type="text" id="edit-kriteria" class="bobot-input" readonly style="width: 100%;">
        </div>
        <div class="form-group">
          <label for="edit-nilai">Nilai (Skala 10-100):</label>
          <input type="number" id="edit-nilai" class="bobot-input" min="10" max="100" step="1" style="width: 100%;">
        </div>
        <div style="text-align: center; margin-top: 20px;">
          <button type="button" class="btn" onclick="closeEditForm()">❌ Batal</button>
          <button type="button" class="btn btn-success" onclick="saveDetail()">💾 Simpan</button>
        </div>
      </form>
    </div>

    <!-- Penjelasan Kriteria -->
    <div class="info-box">
      <h3>📝 Penjelasan Kriteria:</h3>
      <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px; margin-top: 15px;">
        <div>
          <strong>Hasil (30/100)</strong><br>
          <small>Bobot terbesar - efektivitas hasil treatment adalah prioritas utama</small>
        </div>
        <div>
          <strong>Harga (20/100)</strong><br>
          <small>Pertimbangan biaya yang wajar untuk pengguna</small>
        </div>
        <div>
          <strong>Kepuasan (20/100)</strong><br>
          <small>Tingkat kepuasan dan pengalaman pengguna</small>
        </div>
        <div>
          <strong>Durasi (15/100)</strong><br>
          <small>Efisiensi waktu pelaksanaan treatment</small>
        </div>
        <div>
          <strong>Keamanan (15/100)</strong><br>
          <small>Minim efek samping dan keamanan prosedur</small>
        </div>
      </div>
    </div>
  </div>

  <script>
    function updateRowTotal(input, id) {
      const value = parseInt(input.value) || 0;
      
      // Update visual bar
      const bar = document.getElementById('bar-' + id);
      const text = document.getElementById('text-' + id);
      
      if (bar) bar.style.width = value + '%';
      if (text) text.textContent = value + ' / 100';
      
      // Update total
      updateTotal();
    }
    
    function updateTotal() {
      let total = 0;
      const inputs = document.querySelectorAll('.bobot-input[name^="bobot["]');
      
      inputs.forEach(input => {
        total += parseInt(input.value) || 0;
      });
      
      // Update total display
      const totalDisplay = document.getElementById('total-display');
      if (totalDisplay) {
        totalDisplay.textContent = total + ' / 100';
        
        // Update warna
        if (total === 100) {
          totalDisplay.className = 'total-value total-100';
        } else if (total > 100) {
          totalDisplay.className = 'total-value total-over';
        } else {
          totalDisplay.className = 'total-value total-under';
        }
      }
      
      // Show/hide warning
      const warningBox = document.querySelector('.info-box');
      if (warningBox && warningBox.textContent.includes('Perhatian')) {
        if (total !== 100) {
          warningBox.style.display = 'block';
        } else {
          warningBox.style.display = 'none';
        }
      }
      
      return total;
    }
    
    function showEditForm(id, kriteria) {
      document.getElementById('edit-kriteria').value = kriteria;
      document.getElementById('edit-nilai').value = '';
      document.getElementById('edit-form').style.display = 'block';
      document.getElementById('edit-form').setAttribute('data-id', id);
      
      // Scroll to form
      document.getElementById('edit-form').scrollIntoView({ behavior: 'smooth' });
    }
    
    function closeEditForm() {
      document.getElementById('edit-form').style.display = 'none';
    }
    
    function saveDetail() {
      const id = document.getElementById('edit-form').getAttribute('data-id');
      const nilai = document.getElementById('edit-nilai').value;
      
      if (!nilai || nilai < 10 || nilai > 100) {
        alert('Nilai harus antara 10-100');
        return;
      }
      
      alert('Nilai ' + document.getElementById('edit-kriteria').value + ' disimpan: ' + nilai + '/100\n\nCatatan: Untuk implementasi lengkap, simpan ke database.');
      closeEditForm();
    }
    
    // Update total saat halaman dimuat
    document.addEventListener('DOMContentLoaded', function() {
      // Animate bars
      const bars = document.querySelectorAll('.visual-fill');
      bars.forEach(bar => {
        const width = bar.style.width;
        bar.style.width = '0%';
        setTimeout(() => {
          bar.style.width = width;
        }, 100);
      });
      
      // Initialize total
      updateTotal();
    });
    
    // Validasi form
    document.querySelector('form').addEventListener('submit', function(e) {
      if (e.submitter && e.submitter.name === 'update_bobot') {
        const total = updateTotal();
        
        if (Math.abs(total - 100) > 0.01) {
          e.preventDefault();
          alert(' Total bobot harus tepat 100%!\n\nSaat ini: ' + total + '%\n\nSilakan sesuaikan bobot sebelum menyimpan.');
          return false;
        }
        
        return confirm('Yakin ingin menyimpan perubahan bobot?');
      }
    });
  </script>
</body>
</html>